/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.lang;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocal<T> {
    private final Map<Thread, T> contents = new ConcurrentHashMap<Thread, T>();
    private final Supplier<T> initialValueCreator;
    private final Supplier<T> threadValueInitialiser = new Supplier<T>(){

        public T get() {
            Object initialValue = ThreadLocal.this.initialValueCreator.get();
            ThreadLocal.this.set(initialValue);
            return initialValue;
        }
    };

    public ThreadLocal(final T initialValue) {
        this(new Supplier<T>(){

            public T get() {
                return initialValue;
            }
        });
    }

    public ThreadLocal(Supplier<T> initialValueCreator) {
        this.initialValueCreator = (Supplier)Preconditions.checkNotNull(initialValueCreator);
    }

    public void set(T value) {
        this.contents.put(Thread.currentThread(), Preconditions.checkNotNull(value));
    }

    public T get() {
        return (T)Optional.fromNullable(this.contents.get(Thread.currentThread())).or(this.threadValueInitialiser);
    }

    public void remove() {
        this.contents.remove(Thread.currentThread());
    }

    public void reset() {
        this.contents.clear();
    }
}

