/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.lang;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import uk.org.lidalia.lang.Classes;
import uk.org.lidalia.lang.Exceptions;
import uk.org.lidalia.lang.Identity;
import uk.org.lidalia.lang.WrappedValue;

public abstract class RichObject {
    private static final int PRIME = 37;
    private static final int INITIAL_HASHCODE_VALUE = 17;
    private static final LoadingCache<Class<?>, FluentIterable<FieldFacade>> IDENTITY_FIELDS = CacheBuilder.newBuilder().weakKeys().softValues().build((CacheLoader)new IdentityFieldLoader());
    private static final Joiner FIELD_JOINER = Joiner.on((String)",");
    private static final Function<Object, Integer> toHashCode = new Function<Object, Integer>(){

        public Integer apply(Object fieldValue) {
            return fieldValue.hashCode();
        }
    };

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof RichObject) || !Classes.inSameClassHierarchy(this.getClass(), other.getClass())) {
            return false;
        }
        RichObject that = (RichObject)other;
        FluentIterable<FieldFacade> fieldsOfThis = this.fields();
        return fieldsOfThis.toSet().equals((Object)that.fields().toSet()) && fieldsOfThis.allMatch(this.hasEqualValueIn(that));
    }

    private FluentIterable<FieldFacade> fields() {
        try {
            return (FluentIterable)IDENTITY_FIELDS.get(this.getClass());
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e.getCause(), null);
        }
    }

    private Predicate<FieldFacade> hasEqualValueIn(final RichObject other) {
        return new Predicate<FieldFacade>(){

            public boolean apply(FieldFacade field) {
                return RichObject.this.valueOf(field).equals((Object)other.valueOf(field));
            }
        };
    }

    public int hashCode() {
        int result = 17;
        for (FieldFacade field : this.fields()) {
            int toAdd = (Integer)this.valueOf(field).transform(toHashCode).or((Object)0);
            result = 37 * result + toAdd;
        }
        return result;
    }

    public String toString() {
        FluentIterable fieldsAsStrings = this.fields().transform(this.toStringValueOfField());
        return this.getClass().getSimpleName() + "[" + FIELD_JOINER.join((Iterable)fieldsAsStrings) + "]";
    }

    private Function<FieldFacade, String> toStringValueOfField() {
        return new Function<FieldFacade, String>(){

            public String apply(FieldFacade field) {
                return field.getName() + "=" + RichObject.this.valueOf(field).or((Object)"absent");
            }
        };
    }

    private Optional<Object> valueOf(FieldFacade field) {
        return field.valueOn(this);
    }

    private static class FieldFacade
    extends WrappedValue {
        private final Field field;

        FieldFacade(Field field) {
            super(field);
            this.field = field;
        }

        public Optional<Object> valueOn(Object target) {
            try {
                if (!this.field.isAccessible()) {
                    this.makeAccessible();
                }
                return Optional.fromNullable((Object)this.field.get(target));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(this.field + " was not accessible; all fields should be accessible", e);
            }
        }

        public String getName() {
            return this.field.getName();
        }

        public boolean isIdentityField() {
            return this.field.isAnnotationPresent(Identity.class);
        }

        private void makeAccessible() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    FieldFacade.this.field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static class IdentityFieldLoader
    extends CacheLoader<Class<?>, FluentIterable<FieldFacade>> {
        private static final Predicate<FieldFacade> onlyIdentityFields = new Predicate<FieldFacade>(){

            public boolean apply(FieldFacade field) {
                return field.isIdentityField();
            }
        };
        private static final Function<Field, FieldFacade> toFieldFacade = new Function<Field, FieldFacade>(){

            public FieldFacade apply(Field field) {
                return new FieldFacade(field);
            }
        };
        private static final Function<Class<?>, Set<FieldFacade>> toFieldSet = new Function<Class<?>, Set<FieldFacade>>(){

            public Set<FieldFacade> apply(Class<?> input) {
                return IdentityFieldLoader.doLoad(input);
            }
        };

        private IdentityFieldLoader() {
        }

        public FluentIterable<FieldFacade> load(Class<?> key) {
            return FluentIterable.from(IdentityFieldLoader.doLoad(key));
        }

        private static Set<FieldFacade> doLoad(Class<?> key) {
            ImmutableSet localIdentityFieldSet = FluentIterable.from(Arrays.asList(key.getDeclaredFields())).transform(toFieldFacade).filter(onlyIdentityFields).toSet();
            Optional superClass = Optional.fromNullable(key.getSuperclass());
            Set superIdentityFieldSet = (Set)superClass.transform(toFieldSet).or((Object)ImmutableSet.of());
            return Sets.union((Set)localIdentityFieldSet, (Set)superIdentityFieldSet);
        }
    }
}

