/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.propenv;

import java.util.HashMap;
import java.util.Map;
import top.jfunc.common.propenv.Prop;

public class PropertiesUtils {
    private static Prop prop = null;
    private static final Map<String, Prop> map = new HashMap<String, Prop>();

    private PropertiesUtils() {
    }

    public static Prop use(String fileName) {
        return PropertiesUtils.use(fileName, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prop use(String fileName, String encoding) {
        Prop result = map.get(fileName);
        if (result == null) {
            Map<String, Prop> map = PropertiesUtils.map;
            synchronized (map) {
                result = PropertiesUtils.map.get(fileName);
                if (result == null) {
                    result = new Prop(fileName, encoding);
                    PropertiesUtils.map.put(fileName, result);
                    if (prop == null) {
                        prop = result;
                    }
                }
            }
        }
        return result;
    }

    public static Prop useless(String fileName) {
        Prop previous = map.remove(fileName);
        if (prop == previous) {
            prop = null;
        }
        return previous;
    }

    public static void clear() {
        prop = null;
        map.clear();
    }

    public static Prop getProp() {
        if (prop == null) {
            throw new IllegalStateException("Load propties file by invoking PropertiesUtils.use(String fileName) method first.");
        }
        return prop;
    }

    public static Prop getProp(String fileName) {
        return map.get(fileName);
    }

    public static String get(String key) {
        return PropertiesUtils.getProp().get(key);
    }

    public static String get(String key, String defaultValue) {
        return PropertiesUtils.getProp().get(key, defaultValue);
    }

    public static Integer getInt(String key) {
        return PropertiesUtils.getProp().getInt(key);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return PropertiesUtils.getProp().getInt(key, defaultValue);
    }

    public static Long getLong(String key) {
        return PropertiesUtils.getProp().getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return PropertiesUtils.getProp().getLong(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return PropertiesUtils.getProp().getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return PropertiesUtils.getProp().getBoolean(key, defaultValue);
    }

    public static boolean containsKey(String key) {
        return PropertiesUtils.getProp().containsKey(key);
    }
}

