/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.propenv;

import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.propenv.EnvUtil;
import top.jfunc.common.utils.FileUtil;

public abstract class BaseEnvStream {
    private static Logger logger = LoggerFactory.getLogger(BaseEnvStream.class);
    private static String env = EnvUtil.env();

    public InputStream loadEnvInputStream(String fileName) {
        InputStream inputStream = null;
        if (env == null) {
            logger.info("env = null , try to load " + fileName);
            inputStream = this.loadInputStream(fileName);
            if (inputStream == null) {
                throw new IllegalArgumentException("Properties file not found : " + fileName);
            }
        } else {
            String envFileName = FileUtil.getFileNameNoEx(fileName) + "-" + env + "." + FileUtil.getExtensionName(fileName);
            logger.info("env = " + env + " , try to load " + envFileName);
            inputStream = this.loadInputStream(envFileName);
            if (inputStream == null) {
                String envDirName = env + File.separator + fileName;
                logger.info("env = " + env + " , try to load " + envDirName);
                inputStream = this.loadInputStream(envDirName);
                if (inputStream == null) {
                    logger.info("env = " + env + " , try to load " + fileName);
                    inputStream = this.loadInputStream(fileName);
                    if (inputStream == null) {
                        throw new IllegalArgumentException("Properties file not found : " + fileName + ", and " + envFileName + ",and " + envDirName);
                    }
                }
            }
        }
        return inputStream;
    }

    protected abstract InputStream loadInputStream(String var1);
}

