/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.event;

import java.util.List;
import java.util.concurrent.ExecutorService;
import top.jfunc.common.event.core.ApplicationEvent;
import top.jfunc.common.event.core.EventType;
import top.jfunc.common.event.core.ListenerHelper;
import top.jfunc.common.utils.ArrayListMultimap;

public class EventKit {
    private static ArrayListMultimap<EventType, ListenerHelper> map;
    private static ExecutorService pool;

    static void init(ArrayListMultimap<EventType, ListenerHelper> map, ExecutorService pool) {
        EventKit.map = map;
        EventKit.pool = pool;
    }

    public static void post(ApplicationEvent event) {
        EventKit.post("default_tag", event);
    }

    public static void post(String tag, ApplicationEvent event) {
        Class<?> eventClazz = event.getClass();
        EventType eventType = new EventType(tag, eventClazz);
        EventKit.post(eventType, event);
    }

    private static void post(EventType eventType, ApplicationEvent event) {
        List<ListenerHelper> listenerList = map.get(eventType);
        for (ListenerHelper helper : listenerList) {
            if (null != pool && helper.enableAsync) {
                pool.execute(() -> helper.listener.onApplicationEvent(event));
                continue;
            }
            helper.listener.onApplicationEvent(event);
        }
    }
}

