/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatetimeUtils {
    public static final String SDF_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String SDF_DATETIME_SHORT = "yyyyMMddHHmmss";
    public static final String SDF_DATETIME_MS = "yyyyMMddHHmmssSSS";
    public static final String SDF_DATE = "yyyy-MM-dd";

    public static Date toDate(String dateStr) {
        return DatetimeUtils.toDate(dateStr, null);
    }

    public static String toStr(Date date) {
        return DatetimeUtils.toStr(date, SDF_DATETIME);
    }

    public static String toStr(Date date, String format) {
        SimpleDateFormat sdf = null;
        if (null != format && !"".equals(format)) {
            sdf = new SimpleDateFormat(format);
            return sdf.format(date);
        }
        sdf = new SimpleDateFormat(SDF_DATETIME);
        return sdf.format(date);
    }

    public static Date toDate(String dateStr, String pattern) {
        try {
            if (null != pattern && !"".equals(pattern)) {
                return new SimpleDateFormat(pattern).parse(dateStr);
            }
            return new SimpleDateFormat(SDF_DATETIME).parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

