/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatetimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(DatetimeUtil.class);
    private static final Object LOCK_OBJ = new Object();
    private static Map<String, ThreadLocal<SimpleDateFormat>> sdfMap = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getSdf(String pattern) {
        ThreadLocal<SimpleDateFormat> tl = sdfMap.get(pattern);
        if (tl == null) {
            Object object = LOCK_OBJ;
            synchronized (object) {
                tl = sdfMap.get(pattern);
                if (tl == null) {
                    logger.trace("put new sdf of pattern " + pattern + " to map");
                    tl = ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
                    sdfMap.put(pattern, tl);
                }
            }
        }
        return tl.get();
    }

    public static String format(Date date, String pattern) {
        return DatetimeUtil.getSdf(pattern).format(date);
    }

    public static Date parse(String dateStr, String pattern) throws ParseException {
        return DatetimeUtil.getSdf(pattern).parse(dateStr);
    }
}

