/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.TimeZone;
import ru.yandex.clickhouse.ClickHouseUtil;
import ru.yandex.clickhouse.response.ArrayByteFragment;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseValueParser;
import ru.yandex.clickhouse.util.ClickHouseValueFormatter;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseArrayUtil {
    private static final char ARRAY_ELEMENTS_SEPARATOR = ',';
    private static final char STRING_QUOTATION = '\'';
    private static final int MAX_ARRAY_DEPTH = 32;

    private ClickHouseArrayUtil() {
    }

    public static String arrayToString(Object object, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Object must be array");
        }
        if (object.getClass().getComponentType().isPrimitive()) {
            return ClickHouseArrayUtil.primitiveArrayToString(object);
        }
        return ClickHouseArrayUtil.toString((Object[])object, dateTimeZone, dateTimeTimeZone);
    }

    public static String toString(Object[] values, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        if (values.length > 0 && values[0] != null && (values[0].getClass().isArray() || values[0] instanceof Collection)) {
            ArrayBuilder builder = new ArrayBuilder(false, dateTimeZone, dateTimeTimeZone);
            for (Object value : values) {
                if (value instanceof Collection) {
                    Object[] objects = ((Collection)value).toArray();
                    builder.append(ClickHouseArrayUtil.toString(objects, dateTimeZone, dateTimeTimeZone));
                    continue;
                }
                builder.append(ClickHouseArrayUtil.arrayToString(value, dateTimeZone, dateTimeTimeZone));
            }
            return builder.build();
        }
        ArrayBuilder builder = new ArrayBuilder(ClickHouseArrayUtil.needQuote(values), dateTimeZone, dateTimeTimeZone);
        for (Object value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(Collection<?> collection, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
        return ClickHouseArrayUtil.toString(collection.toArray(), dateTimeZone, dateTimeTimeZone);
    }

    public static Object parseArray(ByteFragment value, boolean useObjects, TimeZone timeZone, int arrayLevel, Class<?> elementClass, ClickHouseColumnInfo columnInfo) throws SQLException {
        Object array;
        if (arrayLevel > 32) {
            throw new IllegalArgumentException("Maximum parse depth exceeded");
        }
        if (value.isNull()) {
            return null;
        }
        if (value.charAt(0) != 91 || value.charAt(value.length() - 1) != 93) {
            throw new IllegalArgumentException("not an array: " + value);
        }
        if ((elementClass == Date.class || elementClass == Timestamp.class) && timeZone == null) {
            throw new IllegalArgumentException("Time zone must be provided for date/dateTime array");
        }
        ByteFragment trim = value.subseq(1, value.length() - 2);
        int index = 0;
        if (arrayLevel > 1) {
            int[] dimensions = new int[arrayLevel];
            dimensions[0] = ClickHouseArrayUtil.getArrayLength(trim);
            array = Array.newInstance(useObjects ? elementClass : Utils.unwrap(elementClass), dimensions);
        } else {
            array = Array.newInstance(useObjects ? elementClass : Utils.unwrap(elementClass), ClickHouseArrayUtil.getArrayLength(trim));
        }
        int fieldStart = 0;
        int currentLevel = 0;
        boolean inQuotation = false;
        for (int chIdx = 0; chIdx < trim.length(); ++chIdx) {
            int fieldEnd;
            int ch = trim.charAt(chIdx);
            if (ch == 92) {
                ++chIdx;
            }
            if (!(inQuotation = ch == 39 ^ inQuotation)) {
                if (ch == 91) {
                    ++currentLevel;
                } else if (ch == 93) {
                    --currentLevel;
                }
            }
            if ((inQuotation || ch != 44 || currentLevel != 0) && chIdx != trim.length() - 1) continue;
            int n = fieldEnd = chIdx == trim.length() - 1 ? chIdx + 1 : chIdx;
            if (trim.charAt(fieldStart) == 39) {
                ++fieldStart;
                --fieldEnd;
            }
            ArrayByteFragment fragment = ArrayByteFragment.wrap(trim.subseq(fieldStart, fieldEnd - fieldStart));
            if (arrayLevel > 1) {
                Object arrayValue = ClickHouseArrayUtil.parseArray(fragment, useObjects, timeZone, arrayLevel - 1, elementClass, columnInfo);
                Array.set(array, index++, arrayValue);
            } else {
                Object o = useObjects ? ClickHouseValueParser.getParser(elementClass).parse(fragment, columnInfo, timeZone) : ClickHouseValueParser.getParser(elementClass).parseWithDefault(fragment, columnInfo, timeZone);
                Array.set(array, index++, o);
            }
            fieldStart = chIdx + 1;
        }
        return array;
    }

    public static int getArrayLength(ByteFragment value) {
        if (value.length() == 0) {
            return 0;
        }
        int length = 1;
        boolean inQuotation = false;
        int arrayLevel = 0;
        for (int i = 0; i < value.length(); ++i) {
            int ch = value.charAt(i);
            if (ch == 92) {
                ++i;
            }
            if (inQuotation = ch == 39 ^ inQuotation) continue;
            if (ch == 91) {
                ++arrayLevel;
                continue;
            }
            if (ch == 93) {
                --arrayLevel;
                continue;
            }
            if (ch != 44 || arrayLevel != 0) continue;
            ++length;
        }
        return length;
    }

    public static Object parseArray(ByteFragment value, boolean useObjects, TimeZone timeZone, ClickHouseColumnInfo columnInfo) throws SQLException {
        return ClickHouseArrayUtil.parseArray(value, useObjects, timeZone, columnInfo.getArrayLevel(), columnInfo.getEffectiveClickHouseDataType().getJavaClass(), columnInfo);
    }

    static Object parseArray(ByteFragment value, Class<?> clazz, boolean useObjects, ClickHouseColumnInfo columnInfo) throws SQLException {
        return ClickHouseArrayUtil.parseArray(value, useObjects, null, columnInfo.getArrayLevel(), clazz, columnInfo);
    }

    @Deprecated
    static String toString(Collection<?> collection) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.toString(collection, tz, tz);
    }

    @Deprecated
    static String toString(Object[] values) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.toString(values, tz, tz);
    }

    @Deprecated
    static String arrayToString(Object object) {
        TimeZone tz = TimeZone.getDefault();
        return ClickHouseArrayUtil.arrayToString(object, tz, tz);
    }

    private static String primitiveArrayToString(Object array) {
        if (array instanceof int[]) {
            return ClickHouseArrayUtil.toString((int[])array);
        }
        if (array instanceof long[]) {
            return ClickHouseArrayUtil.toString((long[])array);
        }
        if (array instanceof float[]) {
            return ClickHouseArrayUtil.toString((float[])array);
        }
        if (array instanceof double[]) {
            return ClickHouseArrayUtil.toString((double[])array);
        }
        if (array instanceof char[]) {
            return ClickHouseArrayUtil.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return ClickHouseArrayUtil.toString((byte[])array);
        }
        if (array instanceof short[]) {
            return ClickHouseArrayUtil.toString((short[])array);
        }
        throw new IllegalArgumentException("Wrong primitive type: " + array.getClass().getComponentType());
    }

    private static String toString(int[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (int value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(long[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (long value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(float[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (float value : values) {
            builder.append(Float.valueOf(value));
        }
        return builder.build();
    }

    private static String toString(double[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (double value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(byte[] values) {
        return "'" + ClickHouseValueFormatter.formatBytes(values) + "'";
    }

    private static String toString(short[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (short value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    private static String toString(char[] values) {
        ArrayBuilder builder = new ArrayBuilder(true);
        for (char value : values) {
            builder.append(Character.valueOf(value));
        }
        return builder.build();
    }

    private static boolean needQuote(Object[] objects) {
        Object o = null;
        for (Object u : objects) {
            if (u == null) continue;
            o = u;
            break;
        }
        return objects.length == 0 || ClickHouseValueFormatter.needsQuoting(o);
    }

    private static class ArrayBuilder {
        private final StringBuilder builder;
        private final boolean quote;
        private final TimeZone dateTimeZone;
        private final TimeZone dateTimeTimeZone;
        private int size = 0;
        private boolean built = false;

        private ArrayBuilder(boolean quote) {
            this(quote, TimeZone.getDefault(), TimeZone.getDefault());
        }

        private ArrayBuilder(boolean quote, TimeZone dateTimeZone, TimeZone dateTimeTimeZone) {
            this.quote = quote;
            this.builder = new StringBuilder("[");
            this.dateTimeZone = dateTimeZone;
            this.dateTimeTimeZone = dateTimeTimeZone;
        }

        private ArrayBuilder append(Object value) {
            if (this.built) {
                throw new IllegalStateException("Already built");
            }
            if (this.size > 0) {
                this.builder.append(',');
            }
            if (value != null) {
                if (this.quote) {
                    this.builder.append('\'');
                }
                if (value instanceof String) {
                    this.builder.append(this.quote ? ClickHouseUtil.escape((String)value) : value);
                } else {
                    this.builder.append(ClickHouseValueFormatter.formatObject(value, this.dateTimeZone, this.dateTimeTimeZone));
                }
                if (this.quote) {
                    this.builder.append('\'');
                }
            } else {
                this.builder.append("NULL");
            }
            ++this.size;
            return this;
        }

        private String build() {
            if (!this.built) {
                this.builder.append(']');
                this.built = true;
            }
            return this.builder.toString();
        }
    }
}

