/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public interface ClickHousePreparedStatement
extends PreparedStatement {
    @Override
    default public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setNull(parameterIndex, sqlType, null);
    }

    @Override
    default public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setByte(parameterIndex, x ? (byte)1 : 0);
    }

    @Override
    default public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    default public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    default public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    default public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.US_ASCII), length);
    }

    @Override
    default public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.UTF_8), length);
    }

    @Override
    default public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    default public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    default public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    @Override
    default public void addBatch(String sql) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    default public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        String s = null;
        if (reader != null) {
            try {
                s = BinaryStreamUtils.readString((Reader)reader, (int)length);
            }
            catch (Throwable e) {
                throw SqlExceptionUtils.clientError(e);
            }
        }
        this.setString(parameterIndex, s);
    }

    @Override
    default public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("setRef not implemented");
    }

    @Override
    default public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (x != null) {
            this.setBinaryStream(parameterIndex, x.getBinaryStream());
        } else {
            this.setNull(parameterIndex, 2004);
        }
    }

    @Override
    default public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (x != null) {
            this.setCharacterStream(parameterIndex, x.getCharacterStream());
        } else {
            this.setNull(parameterIndex, 2005);
        }
    }

    @Override
    default public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet currentResult = this.getResultSet();
        return currentResult != null ? currentResult.getMetaData() : null;
    }

    @Override
    default public void setURL(int parameterIndex, URL x) throws SQLException {
        if (x != null) {
            this.setString(parameterIndex, String.valueOf(x));
        } else {
            this.setNull(parameterIndex, 12);
        }
    }

    @Override
    default public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("setRowId not implemented");
    }

    @Override
    default public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    default public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    default public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    default public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    default public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    default public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader, length);
    }

    @Override
    default public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("setSQLXML not implemented");
    }

    @Override
    default public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.US_ASCII), length);
    }

    @Override
    default public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("setBinaryStream not implemented");
    }

    @Override
    default public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw SqlExceptionUtils.unsupportedError("setCharacterStream not implemented");
    }

    @Override
    default public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setCharacterStream(parameterIndex, new InputStreamReader(x, StandardCharsets.US_ASCII));
    }

    @Override
    default public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, 0L);
    }

    @Override
    default public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, 0L);
    }

    @Override
    default public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    default public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    default public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    default public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }
}

