/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.MediaType;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.servlet.ResultMatcher;
import org.w3c.dom.Node;

public class ContentResultMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();
    private final JsonExpectationsHelper jsonHelper = new JsonExpectationsHelper();

    protected ContentResultMatchers() {
    }

    public ResultMatcher contentType(String contentType) {
        return this.contentType(MediaType.parseMediaType((String)contentType));
    }

    public ResultMatcher contentType(MediaType contentType) {
        return result -> {
            String actual = result.getResponse().getContentType();
            AssertionErrors.assertTrue("Content type not set", actual != null);
            if (actual != null) {
                AssertionErrors.assertEquals("Content type", contentType, MediaType.parseMediaType((String)actual));
            }
        };
    }

    public ResultMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)contentType));
    }

    public ResultMatcher contentTypeCompatibleWith(MediaType contentType) {
        return result -> {
            String actual = result.getResponse().getContentType();
            AssertionErrors.assertTrue("Content type not set", actual != null);
            if (actual != null) {
                MediaType actualContentType = MediaType.parseMediaType((String)actual);
                AssertionErrors.assertTrue("Content type [" + actual + "] is not compatible with [" + contentType + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public ResultMatcher encoding(String characterEncoding) {
        return result -> {
            String actual = result.getResponse().getCharacterEncoding();
            AssertionErrors.assertEquals("Character encoding", characterEncoding, actual);
        };
    }

    public ResultMatcher string(Matcher<? super String> matcher) {
        return result -> MatcherAssert.assertThat((String)"Response content", (Object)result.getResponse().getContentAsString(), (Matcher)matcher);
    }

    public ResultMatcher string(String expectedContent) {
        return result -> AssertionErrors.assertEquals("Response content", expectedContent, result.getResponse().getContentAsString());
    }

    public ResultMatcher bytes(byte[] expectedContent) {
        return result -> AssertionErrors.assertEquals("Response content", expectedContent, result.getResponse().getContentAsByteArray());
    }

    public ResultMatcher xml(String xmlContent) {
        return result -> {
            String content = result.getResponse().getContentAsString();
            this.xmlHelper.assertXmlEqual(xmlContent, content);
        };
    }

    public ResultMatcher node(Matcher<? super Node> matcher) {
        return result -> {
            String content = result.getResponse().getContentAsString();
            this.xmlHelper.assertNode(content, matcher);
        };
    }

    public ResultMatcher source(Matcher<? super Source> matcher) {
        return result -> {
            String content = result.getResponse().getContentAsString();
            this.xmlHelper.assertSource(content, matcher);
        };
    }

    public ResultMatcher json(String jsonContent) {
        return this.json(jsonContent, false);
    }

    public ResultMatcher json(String jsonContent, boolean strict) {
        return result -> {
            String content = result.getResponse().getContentAsString();
            this.jsonHelper.assertJsonEqual(jsonContent, content, strict);
        };
    }
}

