/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.shell.MethodTargetRegistrar;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.command.CommandCatalogCustomizer;
import org.springframework.shell.command.CommandRegistration;
import org.springframework.shell.command.CommandResolver;
import org.springframework.shell.context.ShellContext;

@Configuration(proxyBeanMethods=false)
public class CommandCatalogAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CommandCatalog.class})
    public CommandCatalog commandCatalog(ObjectProvider<MethodTargetRegistrar> methodTargetRegistrars, ObjectProvider<CommandResolver> commandResolvers, ObjectProvider<CommandCatalogCustomizer> commandCatalogCustomizers, ShellContext shellContext) {
        List resolvers = commandResolvers.orderedStream().collect(Collectors.toList());
        CommandCatalog catalog = CommandCatalog.of(resolvers, (ShellContext)shellContext);
        methodTargetRegistrars.orderedStream().forEach(resolver -> resolver.register(catalog));
        commandCatalogCustomizers.orderedStream().forEach(customizer -> customizer.customize(catalog));
        return catalog;
    }

    @Bean
    public CommandCatalogCustomizer defaultCommandCatalogCustomizer(ObjectProvider<CommandRegistration> commandRegistrations) {
        return catalog -> commandRegistrations.orderedStream().forEach(registration -> catalog.register(new CommandRegistration[]{registration}));
    }
}

