/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Sort;

abstract class QueryUtils {
    private QueryUtils() {
    }

    public static Query applyPagination(Query query, Pageable pageable) {
        if (pageable == null) {
            return query;
        }
        query.limit(pageable.getPageSize());
        query.skip(pageable.getOffset());
        return QueryUtils.applySorting(query, pageable.getSort());
    }

    public static Query applySorting(Query query, org.springframework.data.domain.Sort sort) {
        if (sort == null) {
            return query;
        }
        Sort bSort = query.sort();
        for (Sort.Order order : sort) {
            bSort.on(order.getProperty(), QueryUtils.toOrder(order));
        }
        return query;
    }

    public static Order toOrder(Sort.Order order) {
        return order.isAscending() ? Order.ASCENDING : Order.DESCENDING;
    }
}

