/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.geo.Box;
import org.springframework.data.mongodb.core.geo.Circle;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.QueryUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongoQueryCreator
extends AbstractQueryCreator<Query, Query> {
    private static final Log LOG = LogFactory.getLog(MongoQueryCreator.class);
    private final MongoParameterAccessor accessor;
    private final boolean isGeoNearQuery;

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor) {
        this(tree, accessor, false);
    }

    public MongoQueryCreator(PartTree tree, ConvertingParameterAccessor accessor, boolean isGeoNearQuery) {
        super(tree, (ParameterAccessor)accessor);
        this.accessor = accessor;
        this.isGeoNearQuery = isGeoNearQuery;
    }

    protected Query create(Part part, Iterator<Object> iterator) {
        if (this.isGeoNearQuery && part.getType().equals((Object)Part.Type.NEAR)) {
            return null;
        }
        Criteria criteria = this.from(part.getType(), Criteria.where(part.getProperty().toDotPath()), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return new Query(criteria);
    }

    protected Query and(Part part, Query base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        Criteria criteria = this.from(part.getType(), Criteria.where(part.getProperty().toDotPath()), (ConvertingParameterAccessor.PotentiallyConvertingIterator)iterator);
        return base.addCriteria(criteria);
    }

    protected Query or(Query base, Query query) {
        return new Query().or(base, query);
    }

    protected Query complete(Query query, Sort sort) {
        QueryUtils.applySorting(query, sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created query " + query.getQueryObject()));
        }
        return query;
    }

    private Criteria from(Part.Type type, Criteria criteria, ConvertingParameterAccessor.PotentiallyConvertingIterator parameters) {
        switch (type) {
            case GREATER_THAN: {
                return criteria.gt(parameters.nextConverted());
            }
            case LESS_THAN: {
                return criteria.lt(parameters.nextConverted());
            }
            case BETWEEN: {
                return criteria.gt(parameters.nextConverted()).lt(parameters.nextConverted());
            }
            case IS_NOT_NULL: {
                return criteria.ne(null);
            }
            case IS_NULL: {
                return criteria.is(null);
            }
            case NOT_IN: {
                return criteria.nin(this.nextAsArray(parameters));
            }
            case IN: {
                return criteria.in(this.nextAsArray(parameters));
            }
            case LIKE: {
                String value = parameters.next().toString();
                return criteria.is(this.toLikeRegex(value));
            }
            case NEAR: {
                Distance distance = this.accessor.getMaxDistance();
                Point point = this.nextAs(parameters, Point.class);
                if (distance == null) {
                    return criteria.near(point);
                }
                if (distance.getMetric() != null) {
                    criteria.nearSphere(point);
                } else {
                    criteria.near(point);
                }
                criteria.maxDistance(distance.getNormalizedValue());
                return criteria;
            }
            case WITHIN: {
                Object parameter = parameters.next();
                if (parameter instanceof Box) {
                    return criteria.withinBox((Box)parameter);
                }
                if (parameter instanceof Circle) {
                    return criteria.withinCenter((Circle)parameter);
                }
                throw new IllegalArgumentException("Parameter has to be either Box or Circle!");
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(parameters.nextConverted());
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.not().is(parameters.nextConverted());
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private <T> T nextAs(Iterator<Object> iterator, Class<T> type) {
        Object parameter = iterator.next();
        if (parameter.getClass().isAssignableFrom(type)) {
            return (T)parameter;
        }
        throw new IllegalArgumentException(String.format("Expected parameter type of %s but got %s!", type, parameter.getClass()));
    }

    private Object[] nextAsArray(ConvertingParameterAccessor.PotentiallyConvertingIterator iterator) {
        Object next = iterator.nextConverted();
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    private Pattern toLikeRegex(String source) {
        String regex = source.replaceAll("\\*", ".*");
        return Pattern.compile(regex);
    }
}

