/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.repository.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.MongoQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class MongoParametersParameterAccessor
extends ParametersParameterAccessor
implements MongoParameterAccessor {
    private final MongoQueryMethod method;

    public MongoParametersParameterAccessor(MongoQueryMethod method, Object[] values) {
        super((Parameters)method.getParameters(), values);
        this.method = method;
    }

    public Distance getMaxDistance() {
        int index = this.method.getParameters().getDistanceIndex();
        return index == -1 ? null : (Distance)this.getValue(index);
    }

    public Point getGeoNearLocation() {
        int nearIndex = this.method.getParameters().getNearIndex();
        if (nearIndex == -1) {
            return null;
        }
        Object value = this.getValue(nearIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof double[]) {
            double[] typedValue = (double[])value;
            if (typedValue.length != 2) {
                throw new IllegalArgumentException("The given double[] must have exactly 2 elements!");
            }
            return new Point(typedValue[0], typedValue[1]);
        }
        return (Point)value;
    }
}

