/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.convert.TypeMapper;
import org.springframework.data.mongodb.core.convert.TypeMapperProvider;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.repository.MongoParameterAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingParameterAccessor
implements MongoParameterAccessor {
    private final MongoWriter<?> writer;
    private final MongoParameterAccessor delegate;

    public ConvertingParameterAccessor(MongoWriter<?> writer, MongoParameterAccessor delegate) {
        this.writer = writer;
        this.delegate = delegate;
    }

    public PotentiallyConvertingIterator iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index));
    }

    @Override
    public Distance getMaxDistance() {
        return this.delegate.getMaxDistance();
    }

    @Override
    public Point getGeoNearLocation() {
        return this.delegate.getGeoNearLocation();
    }

    private Object getConvertedValue(Object value) {
        if (!(this.writer instanceof TypeMapperProvider)) {
            return value;
        }
        TypeMapper mapper = ((TypeMapperProvider)((Object)this.writer)).getTypeMapper();
        return this.removeTypeInfoRecursively(this.writer.convertToMongoType(value), mapper);
    }

    private Object removeTypeInfoRecursively(Object object, TypeMapper mapper) {
        if (!(object instanceof DBObject) || mapper == null) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        String keyToRemove = null;
        for (String key : dbObject.keySet()) {
            Object value;
            if (mapper.isTypeKey(key)) {
                keyToRemove = key;
            }
            if ((value = dbObject.get(key)) instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element, mapper);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value, mapper);
        }
        if (keyToRemove != null) {
            dbObject.removeField(keyToRemove);
        }
        return dbObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public Object nextConverted();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;

        public ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return this.delegate.next();
        }

        @Override
        public Object nextConverted() {
            return ConvertingParameterAccessor.this.getConvertedValue(this.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

