/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.util.Assert;

public class Circle {
    private Point center;
    private double radius;

    @PersistenceConstructor
    public Circle(Point center, double radius) {
        Assert.notNull((Object)center);
        Assert.isTrue((radius >= 0.0 ? 1 : 0) != 0, (String)"Radius must not be negative!");
        this.center = center;
        this.radius = radius;
    }

    public Circle(double centerX, double centerY, double radius) {
        this(new Point(centerX, centerY), radius);
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public String toString() {
        return String.format("Circle [center=%s, radius=%d]", this.center, this.radius);
    }
}

