/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.convert.DefaultTypeMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableTypeMapper
extends DefaultTypeMapper {
    private final Map<TypeInformation<?>, String> typeMap;
    private boolean handleUnmappedClasses = false;

    public ConfigurableTypeMapper(Map<? extends Class<?>, String> sourceTypeMap) {
        Assert.notNull(sourceTypeMap);
        this.typeMap = new HashMap(sourceTypeMap.size());
        for (Map.Entry<Class<?>, String> entry : sourceTypeMap.entrySet()) {
            TypeInformation key = ClassTypeInformation.from(entry.getKey());
            String value = entry.getValue();
            if (this.typeMap.containsValue(value)) {
                throw new IllegalArgumentException(String.format("Detected mapping ambiguity! String %s cannot be mapped to more than one type!", value));
            }
            this.typeMap.put(key, value);
        }
    }

    public void setHandleUnmappedClasses(boolean handleUnmappedClasses) {
        this.handleUnmappedClasses = handleUnmappedClasses;
    }

    @Override
    protected TypeInformation<?> getTypeInformation(String value) {
        for (Map.Entry<TypeInformation<?>, String> entry : this.typeMap.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return this.handleUnmappedClasses ? super.getTypeInformation(value) : null;
    }

    @Override
    protected String getTypeString(TypeInformation<?> typeInformation) {
        String key = this.typeMap.get(typeInformation);
        return key != null ? key : (this.handleUnmappedClasses ? super.getTypeString(typeInformation) : null);
    }
}

