/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.mapping.context.MappingContextAwareBeanPostProcessor;
import org.springframework.data.mongodb.core.convert.CustomConversions;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoConverterParser
extends AbstractBeanDefinitionParser {
    private static final String BASE_PACKAGE = "base-package";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "mappingConverter";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        BeanDefinition conversionsDefinition = this.getCustomConversions(element, parserContext);
        String ctxRef = this.potentiallyCreateMappingContext(element, parserContext, conversionsDefinition);
        try {
            registry.getBeanDefinition("mappingContextAwareBeanPostProcessor");
        }
        catch (NoSuchBeanDefinitionException ignored) {
            BeanDefinitionBuilder postProcBuilder = BeanDefinitionBuilder.genericBeanDefinition(MappingContextAwareBeanPostProcessor.class);
            postProcBuilder.addPropertyValue("mappingContextBeanName", (Object)ctxRef);
            registry.registerBeanDefinition("mappingContextAwareBeanPostProcessor", (BeanDefinition)postProcBuilder.getBeanDefinition());
        }
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        if (!StringUtils.hasText((String)dbFactoryRef)) {
            dbFactoryRef = "mongoDbFactory";
        }
        BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(MappingMongoConverter.class);
        converterBuilder.addConstructorArgReference(dbFactoryRef);
        converterBuilder.addConstructorArgReference(ctxRef);
        if (conversionsDefinition != null) {
            converterBuilder.addPropertyValue("customConversions", (Object)conversionsDefinition);
        }
        try {
            registry.getBeanDefinition("indexCreationHelper");
        }
        catch (NoSuchBeanDefinitionException ignored) {
            if (!StringUtils.hasText((String)dbFactoryRef)) {
                dbFactoryRef = "mongoDbFactory";
            }
            BeanDefinitionBuilder indexHelperBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoPersistentEntityIndexCreator.class);
            indexHelperBuilder.addConstructorArgValue((Object)new RuntimeBeanReference(ctxRef));
            indexHelperBuilder.addConstructorArgValue((Object)new RuntimeBeanReference(dbFactoryRef));
            registry.registerBeanDefinition("indexCreationHelper", (BeanDefinition)indexHelperBuilder.getBeanDefinition());
        }
        return converterBuilder.getBeanDefinition();
    }

    private String potentiallyCreateMappingContext(Element element, ParserContext parserContext, BeanDefinition conversionsDefinition) {
        String ctxRef = element.getAttribute("mapping-context-ref");
        if (!StringUtils.hasText((String)ctxRef)) {
            BeanDefinitionBuilder mappingContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoMappingContext.class);
            Set<String> classesToAdd = this.getInititalEntityClasses(element, mappingContextBuilder);
            if (classesToAdd != null) {
                mappingContextBuilder.addPropertyValue("initialEntitySet", classesToAdd);
            }
            if (conversionsDefinition != null) {
                GenericBeanDefinition simpleTypesDefinition = new GenericBeanDefinition();
                simpleTypesDefinition.setFactoryBeanName("customConversions");
                simpleTypesDefinition.setFactoryMethodName("getSimpleTypeHolder");
                mappingContextBuilder.addPropertyValue("simpleTypeHolder", (Object)simpleTypesDefinition);
            }
            parserContext.getRegistry().registerBeanDefinition("mappingContext", (BeanDefinition)mappingContextBuilder.getBeanDefinition());
            ctxRef = "mappingContext";
        }
        return ctxRef;
    }

    private BeanDefinition getCustomConversions(Element element, ParserContext parserContext) {
        List customConvertersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"custom-converters");
        if (customConvertersElements.size() == 1) {
            Element customerConvertersElement = (Element)customConvertersElements.get(0);
            ManagedList converterBeans = new ManagedList();
            List converterElements = DomUtils.getChildElementsByTagName((Element)customerConvertersElement, (String)"converter");
            if (converterElements != null) {
                for (Element listenerElement : converterElements) {
                    converterBeans.add((Object)this.parseConverter(listenerElement, parserContext));
                }
            }
            BeanDefinitionBuilder conversionsBuilder = BeanDefinitionBuilder.rootBeanDefinition(CustomConversions.class);
            conversionsBuilder.addConstructorArgValue((Object)converterBeans);
            AbstractBeanDefinition conversionsBean = conversionsBuilder.getBeanDefinition();
            conversionsBean.setSource(parserContext.extractSource((Object)element));
            parserContext.getRegistry().registerBeanDefinition("customConversions", (BeanDefinition)conversionsBean);
            return conversionsBean;
        }
        return null;
    }

    public Set<String> getInititalEntityClasses(Element element, BeanDefinitionBuilder builder) {
        String basePackage = element.getAttribute(BASE_PACKAGE);
        if (!StringUtils.hasText((String)basePackage)) {
            return null;
        }
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Document.class));
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Persistent.class));
        ManagedSet classes = new ManagedSet();
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            classes.add(candidate.getBeanClassName());
        }
        return classes;
    }

    public BeanMetadataElement parseConverter(Element element, ParserContext parserContext) {
        String converterRef = element.getAttribute("ref");
        if (StringUtils.hasText((String)converterRef)) {
            return new RuntimeBeanReference(converterRef);
        }
        Element beanElement = DomUtils.getChildElementByTagName((Element)element, (String)"bean");
        if (beanElement != null) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            return beanDef;
        }
        parserContext.getReaderContext().error("Element <converter> must specify 'ref' or contain a bean definition for the converter", (Object)element);
        return null;
    }
}

