/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.log4j;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class MongoLog4jAppender
extends AppenderSkeleton {
    public static final String LEVEL = "level";
    public static final String NAME = "name";
    public static final String APP_ID = "applicationId";
    public static final String TIMESTAMP = "timestamp";
    public static final String PROPERTIES = "properties";
    public static final String TRACEBACK = "traceback";
    public static final String MESSAGE = "message";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    protected String host = "localhost";
    protected int port = 27017;
    protected String database = "logs";
    protected String collectionPattern = "%c";
    protected PatternLayout collectionLayout = new PatternLayout(this.collectionPattern);
    protected String applicationId = System.getProperty("APPLICATION_ID", null);
    protected WriteConcern warnOrHigherWriteConcern = WriteConcern.SAFE;
    protected WriteConcern infoOrLowerWriteConcern = WriteConcern.NORMAL;
    protected Mongo mongo;
    protected DB db;

    public MongoLog4jAppender() {
    }

    public MongoLog4jAppender(boolean isActive) {
        super(isActive);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getCollectionPattern() {
        return this.collectionPattern;
    }

    public void setCollectionPattern(String collectionPattern) {
        this.collectionPattern = collectionPattern;
        this.collectionLayout = new PatternLayout(collectionPattern);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setWarnOrHigherWriteConcern(String wc) {
        this.warnOrHigherWriteConcern = WriteConcern.valueOf((String)wc);
    }

    public String getWarnOrHigherWriteConcern() {
        return this.warnOrHigherWriteConcern.toString();
    }

    public String getInfoOrLowerWriteConcern() {
        return this.infoOrLowerWriteConcern.toString();
    }

    public void setInfoOrLowerWriteConcern(String wc) {
        this.infoOrLowerWriteConcern = WriteConcern.valueOf((String)wc);
    }

    protected void connectToMongo() throws UnknownHostException {
        this.mongo = new Mongo(this.host, this.port);
        this.db = this.mongo.getDB(this.database);
    }

    protected void append(LoggingEvent event) {
        String[] traceback;
        if (null == this.db) {
            try {
                this.connectToMongo();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        BasicDBObject dbo = new BasicDBObject();
        if (null != this.applicationId) {
            dbo.put(APP_ID, (Object)this.applicationId);
            MDC.put((String)APP_ID, (Object)this.applicationId);
        }
        dbo.put(NAME, (Object)event.getLogger().getName());
        dbo.put(LEVEL, (Object)event.getLevel().toString());
        Calendar tstamp = Calendar.getInstance();
        tstamp.setTimeInMillis(event.getTimeStamp());
        dbo.put(TIMESTAMP, (Object)tstamp.getTime());
        Map props = event.getProperties();
        if (null != props && props.size() > 0) {
            BasicDBObject propsDbo = new BasicDBObject();
            for (Map.Entry entry : props.entrySet()) {
                propsDbo.put(entry.getKey().toString(), (Object)entry.getValue().toString());
            }
            dbo.put(PROPERTIES, (Object)propsDbo);
        }
        if (null != (traceback = event.getThrowableStrRep()) && traceback.length > 0) {
            BasicDBList tbDbo = new BasicDBList();
            tbDbo.addAll(Arrays.asList(traceback));
            dbo.put(TRACEBACK, (Object)tbDbo);
        }
        dbo.put(MESSAGE, (Object)event.getRenderedMessage());
        Calendar now = Calendar.getInstance();
        MDC.put((String)YEAR, (Object)now.get(1));
        MDC.put((String)MONTH, (Object)String.format("%1$02d", now.get(2) + 1));
        MDC.put((String)DAY, (Object)String.format("%1$02d", now.get(5)));
        MDC.put((String)HOUR, (Object)String.format("%1$02d", now.get(11)));
        String coll = this.collectionLayout.format(event);
        MDC.remove((String)YEAR);
        MDC.remove((String)MONTH);
        MDC.remove((String)DAY);
        MDC.remove((String)HOUR);
        if (null != this.applicationId) {
            MDC.remove((String)APP_ID);
        }
        WriteConcern wc = event.getLevel().isGreaterOrEqual((Priority)Level.WARN) ? this.warnOrHigherWriteConcern : this.infoOrLowerWriteConcern;
        this.db.getCollection(coll).insert((DBObject)dbo, wc);
    }

    public void close() {
        this.mongo.close();
    }

    public boolean requiresLayout() {
        return true;
    }
}

