/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.ApiClient;
import co.elastic.clients.json.JsonpMapper;
import java.io.IOException;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.client.elc.RequestConverter;
import org.springframework.data.elasticsearch.client.elc.ResponseConverter;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ChildTemplate<CLIENT extends ApiClient> {
    protected final CLIENT client;
    protected final RequestConverter requestConverter;
    protected final ResponseConverter responseConverter;
    protected final ElasticsearchExceptionTranslator exceptionTranslator;

    public ChildTemplate(CLIENT client, ElasticsearchConverter elasticsearchConverter) {
        this.client = client;
        JsonpMapper jsonpMapper = client._transport().jsonpMapper();
        this.requestConverter = new RequestConverter(elasticsearchConverter, jsonpMapper);
        this.responseConverter = new ResponseConverter(jsonpMapper);
        this.exceptionTranslator = new ElasticsearchExceptionTranslator(jsonpMapper);
    }

    public <RESULT> RESULT execute(ClientCallback<CLIENT, RESULT> callback) {
        Assert.notNull(callback, (String)"callback must not be null");
        try {
            return callback.doWithClient(this.client);
        }
        catch (IOException | RuntimeException e) {
            throw this.exceptionTranslator.translateException(e);
        }
    }

    @FunctionalInterface
    public static interface ClientCallback<CLIENT, RESULT> {
        public RESULT doWithClient(CLIENT var1) throws IOException;
    }
}

