/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientException;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.reactive.LoadBalancerCommand;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.ServiceInstanceChooser;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonProperties;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.support.ContextAwareRequest;

public abstract class AbstractLoadBalancingClient<S extends ContextAwareRequest, T extends IResponse, D>
extends AbstractLoadBalancerAwareClient<S, T>
implements ServiceInstanceChooser {
    protected int connectTimeout;
    protected int readTimeout;
    protected boolean secure;
    protected boolean followRedirects;
    protected boolean gzipPayload;
    protected boolean okToRetryOnAllOperations;
    protected final D delegate;
    protected final IClientConfig config;
    protected final ServerIntrospector serverIntrospector;

    public boolean isClientRetryable(ContextAwareRequest request) {
        return false;
    }

    protected AbstractLoadBalancingClient(IClientConfig config, ServerIntrospector serverIntrospector) {
        super(null);
        this.delegate = this.createDelegate(config);
        this.config = config;
        this.serverIntrospector = serverIntrospector;
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(config);
    }

    protected AbstractLoadBalancingClient(D delegate, IClientConfig config, ServerIntrospector serverIntrospector) {
        super(null);
        this.delegate = delegate;
        this.config = config;
        this.serverIntrospector = serverIntrospector;
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.initWithNiwsConfig(config);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        RibbonProperties ribbon = RibbonProperties.from(clientConfig);
        this.connectTimeout = ribbon.connectTimeout(1000);
        this.readTimeout = ribbon.readTimeout(1000);
        this.secure = ribbon.isSecure();
        this.followRedirects = ribbon.isFollowRedirects();
        this.okToRetryOnAllOperations = ribbon.isOkToRetryOnAllOperations();
        this.gzipPayload = ribbon.isGZipPayload(true);
    }

    protected abstract D createDelegate(IClientConfig var1);

    public D getDelegate() {
        return this.delegate;
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(S request, IClientConfig requestConfig) {
        if (this.okToRetryOnAllOperations) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!((ContextAwareRequest)((Object)request)).getContext().getMethod().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    protected boolean isSecure(IClientConfig config) {
        if (config != null) {
            return RibbonProperties.from(config).isSecure(this.secure);
        }
        return this.secure;
    }

    protected void customizeLoadBalancerCommandBuilder(S request, IClientConfig config, LoadBalancerCommand.Builder<T> builder) {
        if (request.getLoadBalancerKey() != null) {
            builder.withServerLocator(request.getLoadBalancerKey());
        }
    }

    public ServiceInstance choose(String serviceId) {
        Server server = this.getLoadBalancer().chooseServer((Object)serviceId);
        if (server != null) {
            return new RibbonLoadBalancerClient.RibbonServer(serviceId, server);
        }
        return null;
    }

    public void validateServiceInstance(ServiceInstance serviceInstance) throws ClientException {
        if (serviceInstance == null) {
            throw new ClientException("Load balancer does not have available server for client: " + this.clientName);
        }
        if (serviceInstance.getHost() == null) {
            throw new ClientException("Invalid Server for: " + serviceInstance.getServiceId() + " null Host");
        }
    }
}

