/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.HeaderRoutePredicateFactory;
import org.springframework.web.server.ServerWebExchange;

public class CloudFoundryRouteServiceRoutePredicateFactory
extends AbstractRoutePredicateFactory<Object> {
    public static final String X_CF_FORWARDED_URL = "X-CF-Forwarded-Url";
    public static final String X_CF_PROXY_SIGNATURE = "X-CF-Proxy-Signature";
    public static final String X_CF_PROXY_METADATA = "X-CF-Proxy-Metadata";
    private final HeaderRoutePredicateFactory factory = new HeaderRoutePredicateFactory();

    public CloudFoundryRouteServiceRoutePredicateFactory() {
        super(Object.class);
    }

    @Override
    public Predicate<ServerWebExchange> apply(Object unused) {
        return this.headerPredicate(X_CF_FORWARDED_URL).and(this.headerPredicate(X_CF_PROXY_SIGNATURE)).and(this.headerPredicate(X_CF_PROXY_METADATA));
    }

    private Predicate<ServerWebExchange> headerPredicate(String header) {
        HeaderRoutePredicateFactory.Config config = (HeaderRoutePredicateFactory.Config)this.factory.newConfig();
        config.setHeader(header);
        config.setRegexp(".*");
        return this.factory.apply(config);
    }
}

