/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepository;
import org.springframework.web.client.RestTemplate;

public class VaultEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<VaultEnvironmentRepository, VaultEnvironmentProperties> {
    private ObjectProvider<HttpServletRequest> request;
    private EnvironmentWatch watch;
    private Optional<VaultRestTemplateFactory> vaultRestTemplateFactory;

    public VaultEnvironmentRepositoryFactory(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, Optional<VaultRestTemplateFactory> vaultRestTemplateFactory) {
        this.request = request;
        this.watch = watch;
        this.vaultRestTemplateFactory = vaultRestTemplateFactory;
    }

    @Override
    public VaultEnvironmentRepository build(VaultEnvironmentProperties environmentProperties) throws Exception {
        if (this.vaultRestTemplateFactory.isPresent()) {
            RestTemplate restTemplate = this.vaultRestTemplateFactory.get().build(environmentProperties);
            return new VaultEnvironmentRepository(this.request, this.watch, restTemplate, environmentProperties);
        }
        return new VaultEnvironmentRepository(this.request, this.watch, new RestTemplate(), environmentProperties);
    }

    public static interface VaultRestTemplateFactory {
        public RestTemplate build(VaultEnvironmentProperties var1) throws Exception;
    }
}

