/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.resilience4j.enabled", "spring.cloud.circuitbreaker.resilience4j.blocking.enabled"}, matchIfMissing=true)
public class Resilience4JAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<Resilience4JCircuitBreakerFactory>> customizers = new ArrayList<Customizer<Resilience4JCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerFactory.class})
    public Resilience4JCircuitBreakerFactory resilience4jCircuitBreakerFactory() {
        Resilience4JCircuitBreakerFactory factory = new Resilience4JCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MeterRegistry.class})
    @ConditionalOnClass(name={"io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics"})
    public static class MicrometerResilience4JCustomizerConfiguration {
        @Autowired(required=false)
        private Resilience4JCircuitBreakerFactory factory;
        @Autowired
        private MeterRegistry meterRegistry;

        @PostConstruct
        public void init() {
            if (this.factory != null) {
                TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)this.factory.getCircuitBreakerRegistry()).bindTo(this.meterRegistry);
            }
        }
    }
}

