/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.alibaba.sentinel.SentinelProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.AbstractDataSourceProperties;
import org.springframework.cloud.alibaba.sentinel.datasource.config.DataSourcePropertiesConfiguration;
import org.springframework.cloud.alibaba.sentinel.datasource.config.NacosDataSourceProperties;
import org.springframework.context.event.EventListener;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SentinelDataSourceHandler {
    private static final Logger logger = LoggerFactory.getLogger(SentinelDataSourceHandler.class);
    private List<String> dataTypeList = Arrays.asList("json", "xml");
    private List<Class> rulesList = Arrays.asList(FlowRule.class, DegradeRule.class, SystemRule.class, AuthorityRule.class, ParamFlowRule.class);
    private List<String> dataSourceBeanNameList = Collections.synchronizedList(new ArrayList());
    private final String DATATYPE_FIELD = "dataType";
    private final String CUSTOM_DATATYPE = "custom";
    private final String CONVERTERCLASS_FIELD = "converterClass";
    @Autowired
    private SentinelProperties sentinelProperties;

    @EventListener(classes={ApplicationStartedEvent.class})
    public void buildDataSource(ApplicationStartedEvent event) throws Exception {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)event.getApplicationContext().getAutowireCapableBeanFactory();
        if (!StringUtils.isEmpty((Object)System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.endpoint"))) {
            TreeMap<String, DataSourcePropertiesConfiguration> newDataSourceMap = new TreeMap<String, DataSourcePropertiesConfiguration>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, DataSourcePropertiesConfiguration> entry : this.sentinelProperties.getDatasource().entrySet()) {
                if (entry.getValue().getValidDataSourceProperties().getClass() == NacosDataSourceProperties.class) continue;
                newDataSourceMap.put(entry.getKey(), entry.getValue());
            }
            newDataSourceMap.put("edas-flow", new DataSourcePropertiesConfiguration(NacosDataSourceProperties.buildFlowByEDAS()));
            newDataSourceMap.put("edas-degrade", new DataSourcePropertiesConfiguration(NacosDataSourceProperties.buildDegradeByEDAS()));
            this.sentinelProperties.setDatasource(newDataSourceMap);
        }
        this.sentinelProperties.getDatasource().forEach((dataSourceName, dataSourceProperties) -> {
            List validFields = dataSourceProperties.getValidField();
            if (validFields.size() != 1) {
                logger.error("[Sentinel Starter] DataSource " + dataSourceName + " multi datasource active and won't loaded: " + dataSourceProperties.getValidField());
                return;
            }
            AbstractDataSourceProperties abstractDataSourceProperties = dataSourceProperties.getValidDataSourceProperties();
            abstractDataSourceProperties.preCheck();
            this.registerBean(beanFactory, abstractDataSourceProperties, dataSourceName + "-sentinel-" + (String)validFields.get(0) + "-datasource");
        });
        this.dataSourceBeanNameList.forEach(beanName -> {
            Object ruleConfig;
            ReadableDataSource dataSource = (ReadableDataSource)beanFactory.getBean(beanName, ReadableDataSource.class);
            try {
                logger.info("[Sentinel Starter] DataSource " + beanName + " start to loadConfig");
                ruleConfig = dataSource.loadConfig();
            }
            catch (Exception e) {
                logger.error("[Sentinel Starter] DataSource " + beanName + " loadConfig error: " + e.getMessage(), (Throwable)e);
                return;
            }
            SentinelProperty sentinelProperty = dataSource.getProperty();
            Class ruleType = this.getAndCheckRuleType(ruleConfig, (String)beanName);
            if (ruleType != null) {
                if (ruleType == FlowRule.class) {
                    FlowRuleManager.register2Property((SentinelProperty)sentinelProperty);
                } else if (ruleType == DegradeRule.class) {
                    DegradeRuleManager.register2Property((SentinelProperty)sentinelProperty);
                } else if (ruleType == SystemRule.class) {
                    SystemRuleManager.register2Property((SentinelProperty)sentinelProperty);
                } else if (ruleType == AuthorityRule.class) {
                    AuthorityRuleManager.register2Property((SentinelProperty)sentinelProperty);
                } else {
                    ParamFlowRuleManager.register2Property((SentinelProperty)sentinelProperty);
                }
            }
        });
    }

    private void registerBean(DefaultListableBeanFactory beanFactory, AbstractDataSourceProperties dataSourceProperties, String dataSourceName) {
        Map propertyMap = Arrays.stream(dataSourceProperties.getClass().getDeclaredFields()).collect(HashMap::new, (m, v) -> {
            try {
                v.setAccessible(true);
                m.put(v.getName(), v.get(dataSourceProperties));
            }
            catch (IllegalAccessException e) {
                logger.error("[Sentinel Starter] DataSource " + dataSourceName + " field: " + v.getName() + " invoke error");
                throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " field: " + v.getName() + " invoke error", e);
            }
        }, HashMap::putAll);
        propertyMap.put("converterClass", dataSourceProperties.getConverterClass());
        propertyMap.put("dataType", dataSourceProperties.getDataType());
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)dataSourceProperties.getFactoryBeanName());
        propertyMap.forEach((propertyName, propertyValue) -> {
            Field field = ReflectionUtils.findField(dataSourceProperties.getClass(), (String)propertyName);
            if (field != null) {
                if ("dataType".equals(propertyName)) {
                    String dataType = StringUtils.trimAllWhitespace((String)propertyValue.toString());
                    if ("custom".equals(dataType)) {
                        try {
                            if (StringUtils.isEmpty((Object)dataSourceProperties.getConverterClass())) {
                                throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + "dataType is custom, please set converter-class property");
                            }
                            String customConvertBeanName = "sentinel-" + dataSourceProperties.getConverterClass();
                            if (!beanFactory.containsBean(customConvertBeanName)) {
                                beanFactory.registerBeanDefinition(customConvertBeanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(Class.forName(dataSourceProperties.getConverterClass())).getBeanDefinition());
                            }
                            builder.addPropertyReference("converter", customConvertBeanName);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("[Sentinel Starter] DataSource " + dataSourceName + " handle " + dataSourceProperties.getClass().getSimpleName() + " error, class name: " + dataSourceProperties.getConverterClass());
                            throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " handle " + dataSourceProperties.getClass().getSimpleName() + " error, class name: " + dataSourceProperties.getConverterClass(), e);
                        }
                    } else {
                        if (!this.dataTypeList.contains(StringUtils.trimAllWhitespace((String)propertyValue.toString()))) {
                            throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " dataType: " + propertyValue + " is not support now. please using these types: " + this.dataTypeList.toString());
                        }
                        builder.addPropertyReference("converter", "sentinel-" + propertyValue.toString() + "-converter");
                    }
                } else {
                    if ("converterClass".equals(propertyName)) {
                        return;
                    }
                    Optional.ofNullable(propertyValue).ifPresent(v -> builder.addPropertyValue(propertyName, v));
                }
            }
        });
        beanFactory.registerBeanDefinition(dataSourceName, (BeanDefinition)builder.getBeanDefinition());
        AbstractDataSource newDataSource = (AbstractDataSource)beanFactory.getBean(dataSourceName);
        if (!StringUtils.isEmpty((Object)System.getProperties().getProperty("spring.cloud.sentinel.nacos.config.endpoint"))) {
            if (dataSourceName.contains("edas-flow")) {
                FlowRuleManager.register2Property((SentinelProperty)newDataSource.getProperty());
            } else if (dataSourceName.contains("edas-degrade")) {
                DegradeRuleManager.register2Property((SentinelProperty)newDataSource.getProperty());
            }
        }
        this.dataSourceBeanNameList.add(dataSourceName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Class getAndCheckRuleType(Object ruleConfig, String dataSourceName) {
        if (this.rulesList.contains(ruleConfig.getClass())) {
            logger.info("[Sentinel Starter] DataSource {} load {} {}", new Object[]{dataSourceName, 1, ruleConfig.getClass().getSimpleName()});
            return ruleConfig.getClass();
        }
        if (!(ruleConfig instanceof List)) {
            logger.error("[Sentinel Starter] DataSource " + dataSourceName + " rule class is invalid. Class: " + ruleConfig.getClass());
            throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " rule class is invalid. Class: " + ruleConfig.getClass());
        }
        List convertedRuleList = (List)ruleConfig;
        if (CollectionUtils.isEmpty((Collection)convertedRuleList)) {
            logger.warn("[Sentinel Starter] DataSource {} rule list is empty.", (Object)dataSourceName);
            return null;
        }
        if (!convertedRuleList.stream().allMatch(rule -> this.rulesList.contains(rule.getClass()))) {
            List classList = convertedRuleList.stream().map(Object::getClass).collect(Collectors.toList());
            logger.error("[Sentinel Starter] DataSource " + dataSourceName + " rule class is invalid. Class List: " + classList);
            throw new RuntimeException("[Sentinel Starter] DataSource " + dataSourceName + " rule class is invalid. Class List: " + classList);
        }
        if (this.rulesList.contains(convertedRuleList.get(0).getClass()) && convertedRuleList.stream().filter(rule -> rule.getClass() == convertedRuleList.get(0).getClass()).toArray().length == convertedRuleList.size()) {
            logger.info("[Sentinel Starter] DataSource {} load {} {}", new Object[]{dataSourceName, convertedRuleList.size(), convertedRuleList.get(0).getClass().getSimpleName()});
            return convertedRuleList.get(0).getClass();
        }
        logger.warn("[Sentinel Starter] DataSource {} all rules are not same rule type and it will not be used. Rule List: {}", (Object)dataSourceName, (Object)convertedRuleList.toString());
        return null;
    }

    public List<String> getDataSourceBeanNameList() {
        return this.dataSourceBeanNameList;
    }
}

