/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.registry;

import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.nacos.NacosDiscoveryProperties;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.StringUtils;

public class NacosServiceRegistry
implements ServiceRegistry<Registration> {
    private static final Logger log = LoggerFactory.getLogger(NacosServiceRegistry.class);
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private final NamingService namingService;

    public NacosServiceRegistry(NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.namingService = nacosDiscoveryProperties.namingServiceInstance();
    }

    public void register(Registration registration) {
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No service to register for nacos client...");
            return;
        }
        String serviceId = registration.getServiceId();
        Instance instance = new Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)this.nacosDiscoveryProperties.getWeight());
        instance.setClusterName(this.nacosDiscoveryProperties.getClusterName());
        instance.setMetadata(registration.getMetadata());
        try {
            this.namingService.registerInstance(serviceId, instance);
            log.info("nacos registry, {} {}:{} register finished", new Object[]{serviceId, instance.getIp(), instance.getPort()});
        }
        catch (Exception e) {
            log.error("nacos registry, {} register failed...{},", new Object[]{serviceId, registration.toString(), e});
        }
    }

    public void deregister(Registration registration) {
        log.info("De-registering from Nacos Server now...");
        if (StringUtils.isEmpty((Object)registration.getServiceId())) {
            log.warn("No dom to de-register for nacos client...");
            return;
        }
        NamingService namingService = this.nacosDiscoveryProperties.namingServiceInstance();
        String serviceId = registration.getServiceId();
        try {
            namingService.deregisterInstance(serviceId, registration.getHost(), registration.getPort(), this.nacosDiscoveryProperties.getClusterName());
        }
        catch (Exception e) {
            log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)e);
        }
        log.info("De-registration finished.");
    }

    public void close() {
    }

    public void setStatus(Registration registration, String status) {
    }

    public <T> T getStatus(Registration registration) {
        return null;
    }
}

