/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.endpoint;

import com.alibaba.nacos.api.config.ConfigService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.NacosPropertySourceRepository;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.util.StringUtils;

public class NacosConfigHealthIndicator
extends AbstractHealthIndicator {
    private final NacosConfigProperties nacosConfigProperties;
    private final NacosPropertySourceRepository nacosPropertySourceRepository;
    private final List<String> dataIds;
    private final ConfigService configService;

    public NacosConfigHealthIndicator(NacosConfigProperties nacosConfigProperties, NacosPropertySourceRepository nacosPropertySourceRepository, ConfigService configService) {
        this.nacosConfigProperties = nacosConfigProperties;
        this.nacosPropertySourceRepository = nacosPropertySourceRepository;
        this.configService = configService;
        this.dataIds = new ArrayList<String>();
        for (NacosPropertySource nacosPropertySource : this.nacosPropertySourceRepository.getAll()) {
            this.dataIds.add(nacosPropertySource.getDataId());
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        for (String dataId : this.dataIds) {
            try {
                String config = this.configService.getConfig(dataId, this.nacosConfigProperties.getGroup(), (long)this.nacosConfigProperties.getTimeout());
                if (!StringUtils.isEmpty((Object)config)) continue;
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.nacosConfigProperties.getGroup()), (Object)"config is empty");
            }
            catch (Exception e) {
                builder.down().withDetail(String.format("dataId: '%s', group: '%s'", dataId, this.nacosConfigProperties.getGroup()), (Object)e.getMessage());
            }
        }
        builder.up().withDetail("dataIds", this.dataIds);
    }
}

