/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.client;

import com.alibaba.nacos.api.config.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySourceBuilder;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=0)
public class NacosPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(NacosPropertySourceLocator.class);
    private static final String NACOS_PROPERTY_SOURCE_NAME = "NACOS";
    private static final String SEP1 = "-";
    private static final String DOT = ".";
    @Autowired
    private NacosConfigProperties nacosConfigProperties;
    private NacosPropertySourceBuilder nacosPropertySourceBuilder;

    public PropertySource<?> locate(Environment env) {
        ConfigService configService = this.nacosConfigProperties.configServiceInstance();
        if (null == configService) {
            logger.warn("no instance of config service found, can't load config from nacos");
            return null;
        }
        long timeout = this.nacosConfigProperties.getTimeout();
        this.nacosPropertySourceBuilder = new NacosPropertySourceBuilder(configService, timeout);
        String name = this.nacosConfigProperties.getName();
        String nacosGroup = this.nacosConfigProperties.getGroup();
        String dataIdPrefix = this.nacosConfigProperties.getPrefix();
        if (StringUtils.isEmpty((Object)dataIdPrefix)) {
            dataIdPrefix = name;
        }
        String fileExtension = this.nacosConfigProperties.getFileExtension();
        CompositePropertySource composite = new CompositePropertySource(NACOS_PROPERTY_SOURCE_NAME);
        this.loadApplicationConfiguration(composite, nacosGroup, dataIdPrefix, fileExtension);
        return composite;
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, String nacosGroup, String dataIdPrefix, String fileExtension) {
        this.loadNacosDataIfPresent(compositePropertySource, dataIdPrefix + DOT + fileExtension, nacosGroup, fileExtension);
        for (String profile : this.nacosConfigProperties.getActiveProfiles()) {
            String dataId = dataIdPrefix + SEP1 + profile + DOT + fileExtension;
            this.loadNacosDataIfPresent(compositePropertySource, dataId, nacosGroup, fileExtension);
        }
    }

    private void loadNacosDataIfPresent(CompositePropertySource composite, String dataId, String group, String fileExtension) {
        NacosPropertySource ps = this.nacosPropertySourceBuilder.build(dataId, group, fileExtension);
        if (ps != null) {
            composite.addFirstPropertySource((PropertySource)ps);
        }
    }
}

