/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.client;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class NacosPropertySourceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(NacosPropertySourceBuilder.class);
    private ConfigService configService;
    private long timeout;

    public NacosPropertySourceBuilder() {
    }

    public NacosPropertySourceBuilder(ConfigService configService, long timeout) {
        this.configService = configService;
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    NacosPropertySource build(String dataId, String group, String fileExtension) {
        Properties p = this.loadNacosData(dataId, group, fileExtension);
        if (p == null) {
            return null;
        }
        return new NacosPropertySource(dataId, this.propertiesToMap(p), new Date());
    }

    private Properties loadNacosData(String dataId, String group, String fileExtension) {
        String data = null;
        try {
            data = this.configService.getConfig(dataId, group, this.timeout);
            if (!StringUtils.isEmpty((Object)data)) {
                logger.info(String.format("Loading nacos data, dataId: '%s', group: '%s'", dataId, group));
                if (fileExtension.equalsIgnoreCase("properties")) {
                    Properties properties = new Properties();
                    properties.load(new StringReader(data));
                    return properties;
                }
                if (fileExtension.equalsIgnoreCase("yaml") || fileExtension.equalsIgnoreCase("yml")) {
                    YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                    yamlFactory.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
                    return yamlFactory.getObject();
                }
            }
        }
        catch (NacosException e) {
            logger.error("get data from Nacos error,dataId:{}, ", (Object)dataId, (Object)e);
        }
        catch (Exception e) {
            logger.error("parse data from Nacos error,dataId:{},data:{},", new Object[]{dataId, data, e});
        }
        return null;
    }

    private Map<String, Object> propertiesToMap(Properties properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (value != null) {
                result.put(key, value.trim());
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

