/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapping;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

class SpringIterableConfigurationPropertySource
extends SpringConfigurationPropertySource
implements IterableConfigurationPropertySource {
    private volatile Cache cache;

    SpringIterableConfigurationPropertySource(EnumerablePropertySource<?> propertySource, PropertyMapper mapper) {
        super((PropertySource<?>)propertySource, mapper, null);
        this.assertEnumerablePropertySource();
    }

    private void assertEnumerablePropertySource() {
        if (this.getPropertySource() instanceof MapPropertySource) {
            try {
                ((Map)((MapPropertySource)this.getPropertySource()).getSource()).size();
            }
            catch (UnsupportedOperationException ex) {
                throw new IllegalArgumentException("PropertySource must be fully enumerable");
            }
        }
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
        ConfigurationProperty configurationProperty = super.getConfigurationProperty(name);
        if (configurationProperty == null) {
            configurationProperty = this.find(this.getPropertyMappings(this.getCache()), name);
        }
        return configurationProperty;
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        return this.getConfigurationPropertyNames().stream();
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return this.getConfigurationPropertyNames().iterator();
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return ConfigurationPropertyState.search(this, name::isAncestorOf);
    }

    private List<ConfigurationPropertyName> getConfigurationPropertyNames() {
        List<ConfigurationPropertyName> names;
        Cache cache = this.getCache();
        List<ConfigurationPropertyName> list = names = cache != null ? cache.getNames() : null;
        if (names != null) {
            return names;
        }
        PropertyMapping[] mappings = this.getPropertyMappings(cache);
        names = new ArrayList<ConfigurationPropertyName>(mappings.length);
        for (PropertyMapping mapping : mappings) {
            names.add(mapping.getConfigurationPropertyName());
        }
        names = Collections.unmodifiableList(names);
        if (cache != null) {
            cache.setNames(names);
        }
        return names;
    }

    private PropertyMapping[] getPropertyMappings(Cache cache) {
        PropertyMapping[] result;
        PropertyMapping[] propertyMappingArray = result = cache != null ? cache.getMappings() : null;
        if (result != null) {
            return result;
        }
        String[] names = this.getPropertySource().getPropertyNames();
        ArrayList mappings = new ArrayList(names.length * 2);
        for (String name : names) {
            Collections.addAll(mappings, this.getMapper().map(name));
        }
        result = mappings.toArray(new PropertyMapping[0]);
        if (cache != null) {
            cache.setMappings(result);
        }
        return result;
    }

    private Cache getCache() {
        CacheKey key = CacheKey.get(this.getPropertySource());
        if (key == null) {
            return null;
        }
        Cache cache = this.cache;
        try {
            if (cache != null && cache.hasKeyEqualTo(key)) {
                return cache;
            }
            this.cache = cache = new Cache(key.copy());
            return cache;
        }
        catch (ConcurrentModificationException ex) {
            return null;
        }
    }

    protected EnumerablePropertySource<?> getPropertySource() {
        return (EnumerablePropertySource)super.getPropertySource();
    }

    private static final class CacheKey {
        private static final CacheKey IMMUTABLE_PROPERTY_SOURCE = new CacheKey(new Object[0]);
        private final Object key;

        private CacheKey(Object key) {
            this.key = key;
        }

        CacheKey copy() {
            if (this == IMMUTABLE_PROPERTY_SOURCE) {
                return IMMUTABLE_PROPERTY_SOURCE;
            }
            return new CacheKey(this.copyKey(this.key));
        }

        private Object copyKey(Object key) {
            if (key instanceof Set) {
                return new HashSet((Set)key);
            }
            return ((String[])key).clone();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey otherCacheKey = (CacheKey)obj;
            return ObjectUtils.nullSafeEquals((Object)this.key, (Object)otherCacheKey.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        static CacheKey get(EnumerablePropertySource<?> source) {
            if (CacheKey.isImmutable(source)) {
                return IMMUTABLE_PROPERTY_SOURCE;
            }
            if (source instanceof MapPropertySource) {
                MapPropertySource mapPropertySource = (MapPropertySource)source;
                return new CacheKey(((Map)mapPropertySource.getSource()).keySet());
            }
            return new CacheKey(source.getPropertyNames());
        }

        private static boolean isImmutable(EnumerablePropertySource<?> source) {
            if (source instanceof OriginLookup) {
                return ((OriginLookup)source).isImmutable();
            }
            if ("systemEnvironment".equals(source.getName())) {
                return source.getSource() == System.getenv();
            }
            return false;
        }
    }

    private static class Cache {
        private final CacheKey key;
        private List<ConfigurationPropertyName> names;
        private PropertyMapping[] mappings;

        Cache(CacheKey key) {
            this.key = key;
        }

        boolean hasKeyEqualTo(CacheKey key) {
            return this.key.equals(key);
        }

        List<ConfigurationPropertyName> getNames() {
            return this.names;
        }

        void setNames(List<ConfigurationPropertyName> names) {
            this.names = names;
        }

        PropertyMapping[] getMappings() {
            return this.mappings;
        }

        void setMappings(PropertyMapping[] mappings) {
            this.mappings = mappings;
        }
    }
}

