/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestArgs;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.servlet.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringBootContextLoader
extends AbstractContextLoader {
    public ApplicationContext loadContext(MergedContextConfiguration config) throws Exception {
        Object[] configClasses = config.getClasses();
        Object[] configLocations = config.getLocations();
        Assert.state((!ObjectUtils.isEmpty((Object[])configClasses) || !ObjectUtils.isEmpty((Object[])configLocations) ? 1 : 0) != 0, () -> "No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ").");
        SpringApplication application = this.getSpringApplication();
        application.setMainApplicationClass(config.getTestClass());
        application.addPrimarySources(Arrays.asList(configClasses));
        application.getSources().addAll(Arrays.asList(configLocations));
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(config, application);
        if (config instanceof WebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.SERVLET);
            if (!this.isEmbeddedWebEnvironment(config)) {
                new WebConfigurer().configure(config, application, initializers);
            }
        } else if (config instanceof ReactiveWebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.REACTIVE);
            if (!this.isEmbeddedWebEnvironment(config)) {
                application.setApplicationContextFactory(ApplicationContextFactory.of(GenericReactiveWebApplicationContext::new));
            }
        } else {
            application.setWebApplicationType(WebApplicationType.NONE);
        }
        application.setInitializers(initializers);
        ConfigurableEnvironment environment = this.getEnvironment(application, config.getActiveProfiles());
        ResourceLoader resourceLoader = application.getResourceLoader() != null ? application.getResourceLoader() : new DefaultResourceLoader(null);
        TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableEnvironment)environment, (ResourceLoader)resourceLoader, (String[])config.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableEnvironment)environment, (String[])this.getInlinedProperties(config));
        application.setEnvironment(environment);
        String[] args = SpringBootTestArgs.get(config.getContextCustomizers());
        return application.run(args);
    }

    private ConfigurableEnvironment getEnvironment(SpringApplication application, String[] activeProfiles) {
        ConfigurableEnvironment environment = this.getEnvironment();
        boolean applicationEnvironment = false;
        if (environment.getClass() == StandardEnvironment.class) {
            environment = application.convertEnvironment(environment);
            applicationEnvironment = true;
        }
        this.setActiveProfiles(environment, activeProfiles, applicationEnvironment);
        return environment;
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles, boolean applicationEnvironment) {
        if (!applicationEnvironment) {
            environment.setActiveProfiles(profiles);
        }
        String[] pairs = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            pairs[i] = "spring.profiles.active[" + i + "]=" + profiles[i];
        }
        TestPropertyValues.of(pairs).applyTo(environment);
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Class[0]);
    }

    protected ConfigurableEnvironment getEnvironment() {
        return new StandardEnvironment();
    }

    protected String[] getInlinedProperties(MergedContextConfiguration config) {
        ArrayList<String> properties = new ArrayList<String>();
        this.disableJmx(properties);
        properties.addAll(Arrays.asList(config.getPropertySourceProperties()));
        return StringUtils.toStringArray(properties);
    }

    private void disableJmx(List<String> properties) {
        properties.add("spring.jmx.enabled=false");
    }

    protected List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration config, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        for (ContextCustomizer contextCustomizer : config.getContextCustomizers()) {
            initializers.add(new ContextCustomizerAdapter(contextCustomizer, config));
        }
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : config.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiateClass((Class)initializerClass));
        }
        if (config.getParent() != null) {
            initializers.add(new ParentContextApplicationContextInitializer(config.getParentApplicationContext()));
        }
        return initializers;
    }

    private boolean isEmbeddedWebEnvironment(MergedContextConfiguration config) {
        return MergedAnnotations.from((AnnotatedElement)config.getTestClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(SpringBootTest.class).getValue("webEnvironment", SpringBootTest.WebEnvironment.class).orElse(SpringBootTest.WebEnvironment.NONE).isEmbedded();
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        super.processContextConfiguration(configAttributes);
        if (!configAttributes.hasResources()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String[] getResourceSuffixes() {
        return new String[]{"-context.xml", "Context.groovy"};
    }

    protected String getResourceSuffix() {
        throw new IllegalStateException();
    }

    @Order(value=-2147483648)
    private static class ParentContextApplicationContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext parent;

        ParentContextApplicationContextInitializer(ApplicationContext parent) {
            this.parent = parent;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.setParent(this.parent);
        }
    }

    private static class ContextCustomizerAdapter
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ContextCustomizer contextCustomizer;
        private final MergedContextConfiguration config;

        ContextCustomizerAdapter(ContextCustomizer contextCustomizer, MergedContextConfiguration config) {
            this.contextCustomizer = contextCustomizer;
            this.config = config;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.contextCustomizer.customizeContext(applicationContext, this.config);
        }
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration configuration, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfiguration = (WebMergedContextConfiguration)configuration;
            this.addMockServletContext(initializers, webConfiguration);
            application.setApplicationContextFactory(webApplicationType -> new GenericWebApplicationContext());
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webConfiguration) {
            SpringBootMockServletContext servletContext = new SpringBootMockServletContext(webConfiguration.getResourceBasePath());
            initializers.add(0, (ApplicationContextInitializer<?>)new ServletContextApplicationContextInitializer((ServletContext)servletContext, true));
        }
    }
}

