/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.codec.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import kotlinx.serialization.json.Json;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.http.codec.autoconfigure.HttpCodecsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.http.codec.json.KotlinSerializationJsonDecoder;
import org.springframework.http.codec.json.KotlinSerializationJsonEncoder;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.WebClient;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration", "org.springframework.boot.jackson2.autoconfigure.Jackson2AutoConfiguration"})
@ConditionalOnClass(value={CodecConfigurer.class, WebClient.class})
public final class CodecsAutoConfiguration {

    static class NoJacksonOrJackson2Preferred
    extends AnyNestedCondition {
        NoJacksonOrJackson2Preferred() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"spring.http.codecs.preferred-json-mapper"}, havingValue="jackson2")
        static class Jackson2Preferred {
            Jackson2Preferred() {
            }
        }

        @ConditionalOnMissingClass(value={"tools.jackson.databind.json.JsonMapper"})
        static class NoJackson {
            NoJackson() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={HttpCodecsProperties.class})
    static class DefaultCodecsConfiguration {
        DefaultCodecsConfiguration() {
        }

        @Bean
        DefaultCodecCustomizer defaultCodecCustomizer(HttpCodecsProperties httpCodecProperties) {
            return new DefaultCodecCustomizer(httpCodecProperties.isLogRequestDetails(), httpCodecProperties.getMaxInMemorySize());
        }

        static final class DefaultCodecCustomizer
        implements CodecCustomizer,
        Ordered {
            private final boolean logRequestDetails;
            private final @Nullable DataSize maxInMemorySize;

            DefaultCodecCustomizer(boolean logRequestDetails, @Nullable DataSize maxInMemorySize) {
                this.logRequestDetails = logRequestDetails;
                this.maxInMemorySize = maxInMemorySize;
            }

            @Override
            public void customize(CodecConfigurer configurer) {
                PropertyMapper map = PropertyMapper.get();
                CodecConfigurer.DefaultCodecs defaultCodecs = configurer.defaultCodecs();
                defaultCodecs.enableLoggingRequestDetails(this.logRequestDetails);
                map.from((Object)this.maxInMemorySize).asInt(DataSize::toBytes).to(arg_0 -> ((CodecConfigurer.DefaultCodecs)defaultCodecs).maxInMemorySize(arg_0));
            }

            public int getOrder() {
                return 0;
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Json.class})
    static class KotlinxSerializationJsonCodecConfiguration {
        KotlinxSerializationJsonCodecConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Json.class})
        CodecCustomizer kotlinxJsonCodecCustomizer(Json json, ResourceLoader resourceLoader) {
            ClassLoader classLoader = resourceLoader.getClassLoader();
            boolean hasAnyJsonSupport = ClassUtils.isPresent((String)"tools.jackson.databind.json.JsonMapper", (ClassLoader)classLoader) || ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) || ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.kotlinSerializationJsonEncoder((Encoder)(hasAnyJsonSupport ? new KotlinSerializationJsonEncoder(json) : new KotlinSerializationJsonEncoder(json, type -> true)));
                defaults.kotlinSerializationJsonDecoder((Decoder)(hasAnyJsonSupport ? new KotlinSerializationJsonDecoder(json) : new KotlinSerializationJsonDecoder(json, type -> true)));
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    @Conditional(value={NoJacksonOrJackson2Preferred.class})
    @Deprecated(since="4.0.0", forRemoval=true)
    static class Jackson2JsonCodecConfiguration {
        Jackson2JsonCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jackson2CodecCustomizer(ObjectMapper objectMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jacksonJsonDecoder((Decoder)new Jackson2JsonDecoder(objectMapper, new MimeType[0]));
                defaults.jacksonJsonEncoder((Encoder)new Jackson2JsonEncoder(objectMapper, new MimeType[0]));
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JsonMapper.class})
    @ConditionalOnProperty(name={"spring.http.codecs.preferred-json-mapper"}, havingValue="jackson", matchIfMissing=true)
    static class JacksonJsonCodecConfiguration {
        JacksonJsonCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={JsonMapper.class})
        CodecCustomizer jacksonCodecCustomizer(JsonMapper jsonMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jacksonJsonDecoder((Decoder)new JacksonJsonDecoder(jsonMapper));
                defaults.jacksonJsonEncoder((Encoder)new JacksonJsonEncoder(jsonMapper));
            };
        }
    }
}

