/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.War;
import org.springframework.boot.gradle.tasks.bundling.BootArchive;
import org.springframework.boot.gradle.tasks.bundling.BootArchiveSupport;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;

public class BootWar
extends War
implements BootArchive {
    private static final String LAUNCHER = "org.springframework.boot.loader.WarLauncher";
    private static final String CLASSES_DIRECTORY = "WEB-INF/classes/";
    private static final String LIB_PROVIDED_DIRECTORY = "WEB-INF/lib-provided/";
    private static final String LIB_DIRECTORY = "WEB-INF/lib/";
    private final BootArchiveSupport support = new BootArchiveSupport("org.springframework.boot.loader.WarLauncher", new LibrarySpec(), new ZipCompressionResolver());
    private final Property<String> mainClass = this.getProject().getObjects().property(String.class);
    private FileCollection providedClasspath;

    public BootWar() {
        this.getWebInf().into((Object)"lib-provided", BootWar.fromCallTo(this::getProvidedLibFiles));
        this.support.moveModuleInfoToRoot((CopySpec)this.getRootSpec());
        this.getRootSpec().eachFile(this.support::excludeNonZipLibraryFiles);
    }

    private Object getProvidedLibFiles() {
        return this.providedClasspath != null ? this.providedClasspath : Collections.emptyList();
    }

    public void copy() {
        this.support.configureManifest(this.getManifest(), (String)this.getMainClass().get(), CLASSES_DIRECTORY, LIB_DIRECTORY, null, null);
        super.copy();
    }

    protected CopyAction createCopyAction() {
        return this.support.createCopyAction((Jar)this);
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    @Deprecated
    public String getMainClassName() {
        return (String)this.mainClass.getOrNull();
    }

    @Override
    @Deprecated
    public void setMainClassName(String mainClassName) {
        this.mainClass.set((Object)mainClassName);
    }

    @Override
    public void requiresUnpack(String ... patterns) {
        this.support.requiresUnpack(patterns);
    }

    @Override
    public void requiresUnpack(Spec<FileTreeElement> spec) {
        this.support.requiresUnpack(spec);
    }

    @Override
    public LaunchScriptConfiguration getLaunchScript() {
        return this.support.getLaunchScript();
    }

    @Override
    public void launchScript() {
        this.enableLaunchScriptIfNecessary();
    }

    @Override
    public void launchScript(Action<LaunchScriptConfiguration> action) {
        action.execute((Object)this.enableLaunchScriptIfNecessary());
    }

    @Optional
    @Classpath
    public FileCollection getProvidedClasspath() {
        return this.providedClasspath;
    }

    public void providedClasspath(Object ... classpath) {
        FileCollection existingClasspath = this.providedClasspath;
        this.providedClasspath = this.getProject().files(new Object[]{existingClasspath != null ? existingClasspath : Collections.emptyList(), classpath});
    }

    public void setProvidedClasspath(FileCollection classpath) {
        this.providedClasspath = this.getProject().files(new Object[]{classpath});
    }

    public void setProvidedClasspath(Object classpath) {
        this.providedClasspath = this.getProject().files(new Object[]{classpath});
    }

    @Override
    @Deprecated
    public boolean isExcludeDevtools() {
        return this.support.isExcludeDevtools();
    }

    @Override
    @Deprecated
    public void setExcludeDevtools(boolean excludeDevtools) {
        this.support.setExcludeDevtools(excludeDevtools);
    }

    protected ZipCompression resolveZipCompression(FileCopyDetails details) {
        return this.isLibrary(details) ? ZipCompression.STORED : ZipCompression.DEFLATED;
    }

    protected boolean isLibrary(FileCopyDetails details) {
        String path = details.getRelativePath().getPathString();
        return path.startsWith(LIB_DIRECTORY) || path.startsWith(LIB_PROVIDED_DIRECTORY);
    }

    private LaunchScriptConfiguration enableLaunchScriptIfNecessary() {
        LaunchScriptConfiguration launchScript = this.support.getLaunchScript();
        if (launchScript == null) {
            launchScript = new LaunchScriptConfiguration((AbstractArchiveTask)this);
            this.support.setLaunchScript(launchScript);
        }
        return launchScript;
    }

    private static <T> Action<CopySpec> fromCallTo(Callable<T> callable) {
        return spec -> spec.from(new Object[]{BootWar.callTo(callable)});
    }

    private static <T> Callable<T> callTo(Callable<T> callable) {
        return callable;
    }

    private final class ZipCompressionResolver
    implements Function<FileCopyDetails, ZipCompression> {
        private ZipCompressionResolver() {
        }

        @Override
        public ZipCompression apply(FileCopyDetails details) {
            return BootWar.this.resolveZipCompression(details);
        }
    }

    private final class LibrarySpec
    implements Spec<FileCopyDetails> {
        private LibrarySpec() {
        }

        public boolean isSatisfiedBy(FileCopyDetails details) {
            return BootWar.this.isLibrary(details);
        }
    }
}

