/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;

public class VectorSelectOperator
extends Operator<SelectDesc>
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    protected VectorExpression[] vExpressions = null;
    private transient int[] projectedColumns = null;
    private transient VectorExpressionWriter[] valueWriters = null;
    private VectorizationContext vOutContext;

    public VectorSelectOperator(VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        VectorExpression ve;
        int i;
        this.conf = (SelectDesc)conf;
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        this.vExpressions = new VectorExpression[colList.size()];
        for (i = 0; i < colList.size(); ++i) {
            ExprNodeDesc expr = colList.get(i);
            this.vExpressions[i] = ve = vContext.getVectorExpression(expr);
        }
        this.vOutContext = new VectorizationContext(this.getName(), vContext);
        this.vOutContext.resetProjectionColumns();
        for (i = 0; i < colList.size(); ++i) {
            String columnName = ((SelectDesc)this.conf).getOutputColumnNames().get(i);
            ve = this.vExpressions[i];
            this.vOutContext.addProjectionColumn(columnName, ve.getOutputColumn());
        }
    }

    public VectorSelectOperator() {
    }

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        Collection<Future<?>> result = super.initializeOp(hconf);
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            return null;
        }
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>();
        List<ExprNodeDesc> colList = ((SelectDesc)this.conf).getColList();
        for (VectorExpressionWriter vew : this.valueWriters = VectorExpressionWriterFactory.getExpressionWriters(colList)) {
            objectInspectors.add(vew.getObjectInspector());
        }
        List<String> outputFieldNames = ((SelectDesc)this.conf).getOutputColumnNames();
        this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(outputFieldNames, objectInspectors);
        this.projectedColumns = new int[this.vExpressions.length];
        for (int i = 0; i < this.projectedColumns.length; ++i) {
            this.projectedColumns[i] = this.vExpressions[i].getOutputColumn();
        }
        return result;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        if (((SelectDesc)this.conf).isSelStarNoCompute()) {
            this.forward(row, this.inputObjInspectors[tag]);
            return;
        }
        VectorizedRowBatch vrg = (VectorizedRowBatch)row;
        for (int i = 0; i < this.vExpressions.length; ++i) {
            try {
                this.vExpressions[i].evaluate(vrg);
                continue;
            }
            catch (RuntimeException e) {
                throw new HiveException("Error evaluating " + ((SelectDesc)this.conf).getColList().get(i).getExprString(), e);
            }
        }
        VectorExpressionWriter[] originalValueWriters = vrg.valueWriters;
        vrg.setValueWriters(this.valueWriters);
        int[] originalProjections = vrg.projectedColumns;
        int originalProjectionSize = vrg.projectionSize;
        vrg.projectionSize = this.vExpressions.length;
        vrg.projectedColumns = this.projectedColumns;
        this.forward(vrg, this.outputObjInspector);
        vrg.projectionSize = originalProjectionSize;
        vrg.projectedColumns = originalProjections;
        vrg.valueWriters = originalValueWriters;
    }

    public static String getOperatorName() {
        return "SEL";
    }

    public VectorExpression[] getvExpressions() {
        return this.vExpressions;
    }

    public VectorExpression[] getVExpressions() {
        return this.vExpressions;
    }

    public void setvExpressions(VectorExpression[] vExpressions) {
        this.vExpressions = vExpressions;
    }

    public void setVExpressions(VectorExpression[] vExpressions) {
        this.vExpressions = vExpressions;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SELECT;
    }
}

