/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.smx;

import com.emc.codec.EncodeMetadata;
import com.emc.codec.encryption.EncryptionUtil;
import java.util.HashMap;
import java.util.Map;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMXEncryptionMetadata
extends EncodeMetadata {
    private static final Logger log = LoggerFactory.getLogger(SMXEncryptionMetadata.class);
    private long originalSize;
    private byte[] originalDigest;
    private String keyId;
    private String encryptedKey;
    private byte[] initVector;

    public SMXEncryptionMetadata(String encodeSpec) {
        super(encodeSpec);
    }

    public SMXEncryptionMetadata(String encodeSpec, Map<String, String> metaMap) {
        this(encodeSpec);
        String iv = metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_IV);
        if (iv != null) {
            this.initVector = EncryptionUtils.urlSafeDecodeBase64(iv);
        } else {
            log.debug("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u7b97\u6cd5\u7684\u521d\u59cb\u5316\u5411\u91cf\uff08initialization vector, IV)\uff0c\u6216\u8bb8\u7b97\u6cd5\u7684\u586b\u5145\u6a21\u5f0f\u662f ECB\u3002");
        }
        this.keyId = metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_KEY_ID);
        if (this.keyId == null) {
            throw new EncryptionException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11 key ID\u3002");
        }
        this.encryptedKey = metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_MESSAGE_KEY);
        if (this.encryptedKey == null) {
            throw new EncryptionException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u6570\u636e\u5bf9\u79f0\u52a0\u5bc6\uff08SM4\uff09\u7684\u5bc6\u94a5\u3002");
        }
        String originalDigestStr = metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SM3);
        if (originalDigestStr == null) {
            throw new EncryptionException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u52a0\u5bc6\u524d\u7684 SM3 \u6458\u8981\u503c\u3002");
        }
        this.originalDigest = EncryptionUtils.decodeHex(originalDigestStr);
        String originalSizeStr = metaMap.get(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SIZE);
        if (originalSizeStr == null) {
            throw new EncryptionException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11\u52a0\u5bc6\u524d\u7684\u6570\u636e\u5927\u5c0f\u3002");
        }
        this.originalSize = Long.parseLong(originalSizeStr);
    }

    public boolean isComplete() {
        return this.originalDigest != null && this.keyId != null && this.encryptedKey != null;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        if (this.initVector != null) {
            metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_IV, EncryptionUtils.urlSafeEncodeBase64(this.initVector));
        }
        metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_MESSAGE_KEY, this.encryptedKey);
        if (this.isComplete()) {
            metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SM3, EncryptionUtil.toHexPadded((byte[])this.originalDigest));
            metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_UNENC_SIZE, "" + this.originalSize);
            metaMap.put(SMXEncryptionConstants.META_ENCRYPTION_KEY_ID, this.keyId);
        }
        return metaMap;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    public byte[] getOriginalDigest() {
        return this.originalDigest;
    }

    public void setOriginalDigest(byte[] originalDigest) {
        this.originalDigest = originalDigest;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setEncryptedKey(String encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public byte[] getInitVector() {
        return this.initVector;
    }

    public void setInitVector(byte[] initVector) {
        this.initVector = initVector;
    }
}

