/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.smx;

import com.emc.codec.EncodeInputStream;
import com.emc.codec.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionMetadata;

public class SMXEncryptionInputStream
extends EncodeInputStream<SMXEncryptionMetadata> {
    private final SMXEncryptionMetadata metadata;
    boolean closed = false;
    private final DigestInputStream digestStream;
    private final CountingInputStream counterStream;

    public SMXEncryptionInputStream(InputStream originalStream, String encodeSpec, Cipher cipher, String encryptedKey) {
        super(originalStream);
        this.metadata = new SMXEncryptionMetadata(encodeSpec);
        this.metadata.setEncryptedKey(encryptedKey);
        if (!encodeSpec.contains("/ECB/")) {
            this.metadata.setInitVector(cipher.getIV());
        }
        try {
            this.counterStream = new CountingInputStream(originalStream);
            this.digestStream = new DigestInputStream((InputStream)this.counterStream, MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER));
            this.in = new CipherInputStream(this.digestStream, cipher);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize digest", e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.counterStream.getByteCount());
        this.metadata.setOriginalDigest(this.digestStream.getMessageDigest().digest());
        this.notifyListeners();
    }

    public SMXEncryptionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

