/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.smx;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeListener;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.EncodeStream;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionInputStream;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionMetadata;
import org.opoo.ootp.codec.encryption.smx.SMXEncryptionOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMXEncryptionCodec
extends AbstractCodec<SMXEncryptionMetadata> {
    private static final Logger log = LoggerFactory.getLogger(SMXEncryptionCodec.class);
    public static final int PRIORITY = 1000;
    public static final String SM4_CBC_PKCS5_CIPHER = "SM4/CBC/PKCS5Padding";
    public static final String ECB_INDICATOR = "/ECB/";
    public static final String PROP_PUBLIC_KEY = "org.opoo.ootp.codec.encryption.smx.SMXEncryptionCodec.publicKey";
    public static final String PROP_PRIVATE_KEY_PROVIDER = "org.opoo.ootp.codec.encryption.smx.SMXEncryptionCodec.privateKeyProvider";

    public boolean canProcess(String encodeSpec) {
        if (!"SMX".equals(CodecUtil.getEncodeType((String)encodeSpec))) {
            return false;
        }
        String cipherSpec = EncryptionUtils.getCipherSpec(encodeSpec);
        return cipherSpec.toUpperCase().startsWith("SM4/");
    }

    public String getDefaultEncodeSpec() {
        return CodecUtil.getEncodeSpec((String)"SMX", (String)SM4_CBC_PKCS5_CIPHER);
    }

    public int getPriority() {
        return 1000;
    }

    public SMXEncryptionMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        return new SMXEncryptionMetadata(encodeSpec, metaMap);
    }

    public long getDecodedSize(SMXEncryptionMetadata metadata) {
        return metadata.getOriginalSize();
    }

    public OutputStream getDecodingStream(OutputStream originalStream, SMXEncryptionMetadata metadata, Map<String, Object> codecProperties) {
        Cipher cipher = this.createDecryptCipher(metadata, codecProperties);
        return new CipherOutputStream(originalStream, cipher);
    }

    public InputStream getDecodingStream(InputStream originalStream, SMXEncryptionMetadata metadata, Map<String, Object> codecProperties) {
        Cipher cipher = this.createDecryptCipher(metadata, codecProperties);
        return new CipherInputStream(originalStream, cipher);
    }

    protected Cipher createDecryptCipher(SMXEncryptionMetadata metadata, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtils.getCipherSpec(metadata.getEncodeSpec());
        log.debug("\u4ece\u4e0a\u4e0b\u6587\u83b7\u53d6\u5f53\u524d\u7528\u4e8e\u89e3\u5bc6\u7684\u5bc6\u94a5\u4ed3\u5e93");
        PrivateKeyProvider keyProvider = (PrivateKeyProvider)Codec.getContextProperty(codecProperties, PROP_PRIVATE_KEY_PROVIDER, () -> new EncryptionException("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u5f53\u524d\u89e3\u5bc6\u8fc7\u7a0b\u7f3a\u5c11\u5bc6\u94a5\u4ed3\u5e93"));
        String fingerprint = metadata.getKeyId();
        log.debug("\u6839\u636e\u6307\u7eb9\u67e5\u8be2\u66fe\u7ecf\u7528\u4e8e\u52a0\u5bc6\u7684\u516c\u94a5\u5bf9\u5e94\u7684\u79c1\u94a5\uff1a{}", (Object)fingerprint);
        PrivateKey privateKey = keyProvider.getKey(fingerprint);
        if (privateKey == null) {
            throw new EncryptionException(String.format("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u7f3a\u5c11\u5bf9\u5e94\u7684\u79c1\u94a5\uff0cID: %s", metadata.getKeyId()));
        }
        String encryptedKey = metadata.getEncryptedKey();
        byte[] initVector = metadata.getInitVector();
        SecretKey secretKey = EncryptionUtils.decryptKey(encryptedKey, EncryptionUtils.getBaseAlgorithm(cipherSpec), privateKey);
        IvParameterSpec spec = initVector != null ? new IvParameterSpec(initVector) : null;
        return EncryptionUtils.initCipher(cipherSpec, 2, secretKey, spec);
    }

    public boolean isSizePredictable() {
        return false;
    }

    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        throw new UnsupportedOperationException("sm4 encoded size is unpredictable");
    }

    public EncodeOutputStream<SMXEncryptionMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtils.getCipherSpec(encodeSpec);
        SecretKey secretKey = EncryptionUtils.generateKey(cipherSpec);
        Cipher cipher = EncryptionUtils.initCipher(cipherSpec, 1, secretKey, null);
        PublicKey publicKey = (PublicKey)Codec.getContextProperty(codecProperties, PROP_PUBLIC_KEY, () -> new EncryptionException("\u65e0\u6cd5\u52a0\u5bc6\uff0c\u7f3a\u5c11\u516c\u94a5"));
        String encryptedKey = EncryptionUtils.encryptKey(secretKey, publicKey);
        SMXEncryptionOutputStream eos = new SMXEncryptionOutputStream(originalStream, encodeSpec, cipher, encryptedKey);
        eos.addListener(new SigningEncodeMetadataListener(publicKey));
        return eos;
    }

    public EncodeInputStream<SMXEncryptionMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtils.getCipherSpec(encodeSpec);
        SecretKey secretKey = EncryptionUtils.generateKey(cipherSpec);
        Cipher cipher = EncryptionUtils.initCipher(cipherSpec, 1, secretKey, null);
        PublicKey publicKey = (PublicKey)Codec.getContextProperty(codecProperties, PROP_PUBLIC_KEY, () -> new EncryptionException("\u65e0\u6cd5\u52a0\u5bc6\uff0c\u7f3a\u5c11\u516c\u94a5"));
        String encryptedKey = EncryptionUtils.encryptKey(secretKey, publicKey);
        SMXEncryptionInputStream eis = new SMXEncryptionInputStream(originalStream, encodeSpec, cipher, encryptedKey);
        eis.addListener(new SigningEncodeMetadataListener(publicKey));
        return eis;
    }

    protected static class SigningEncodeMetadataListener
    implements EncodeListener<SMXEncryptionMetadata> {
        private final PublicKey publicKey;

        public SigningEncodeMetadataListener(PublicKey publicKey) {
            this.publicKey = publicKey;
        }

        public void encodeComplete(EncodeStream<SMXEncryptionMetadata> encodeStream) {
            ((SMXEncryptionMetadata)encodeStream.getEncodeMetadata()).setKeyId(EncryptionUtils.getKeyFingerprint(this.publicKey));
        }
    }
}

