/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.sm4;

import com.emc.codec.EncodeOutputStream;
import com.emc.codec.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionMetadata;

public class SM4EncryptionOutputStream
extends EncodeOutputStream<SM4EncryptionMetadata> {
    private final SM4EncryptionMetadata metadata;
    boolean closed = false;
    private final DigestOutputStream digestStream;
    private final CountingOutputStream counterStream;

    public SM4EncryptionOutputStream(OutputStream originalStream, String encodeSpec, Cipher cipher) {
        super(originalStream);
        this.metadata = new SM4EncryptionMetadata(encodeSpec);
        try {
            CipherOutputStream cipherStream = new CipherOutputStream(originalStream, cipher);
            this.digestStream = new DigestOutputStream(cipherStream, MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER));
            this.counterStream = new CountingOutputStream((OutputStream)this.digestStream);
            this.out = this.counterStream;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize digest", e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.counterStream.getByteCount());
        this.metadata.setOriginalDigest(this.digestStream.getMessageDigest().digest());
        this.notifyListeners();
    }

    public SM4EncryptionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

