/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.sm4;

import com.emc.codec.EncodeMetadata;
import com.emc.codec.encryption.EncryptionUtil;
import java.util.HashMap;
import java.util.Map;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionConstants;

public class SM4EncryptionMetadata
extends EncodeMetadata {
    private long originalSize;
    private byte[] originalDigest;
    private String keyHash;

    public SM4EncryptionMetadata(String encodeSpec) {
        super(encodeSpec);
    }

    public SM4EncryptionMetadata(String encodeSpec, Map<String, String> metaMap) {
        this(encodeSpec);
        this.keyHash = metaMap.get(SM4EncryptionConstants.META_ENCRYPTION_KEY_HASH);
        if (this.keyHash == null) {
            throw new EncryptionException("no key hash set on object.");
        }
        String originalDigestStr = metaMap.get(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SM3);
        if (originalDigestStr == null) {
            throw new EncryptionException("no SM3 digest set on object.");
        }
        this.originalDigest = EncryptionUtils.decodeHex(originalDigestStr);
        String originalSizeStr = metaMap.get(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SIZE);
        if (originalSizeStr == null) {
            throw new EncryptionException("no original size set on object.");
        }
        this.originalSize = Long.parseLong(originalSizeStr);
    }

    public boolean isComplete() {
        return this.originalDigest != null && this.keyHash != null;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        if (this.isComplete()) {
            metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SM3, EncryptionUtil.toHexPadded((byte[])this.originalDigest));
            metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_UNENC_SIZE, "" + this.originalSize);
            metaMap.put(SM4EncryptionConstants.META_ENCRYPTION_KEY_HASH, this.keyHash);
        }
        return metaMap;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    public byte[] getOriginalDigest() {
        return this.originalDigest;
    }

    public void setOriginalDigest(byte[] originalDigest) {
        this.originalDigest = originalDigest;
    }

    public String getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(String keyHash) {
        this.keyHash = keyHash;
    }
}

