/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.sm4;

import com.emc.codec.EncodeInputStream;
import com.emc.codec.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionMetadata;

public class SM4EncryptionInputStream
extends EncodeInputStream<SM4EncryptionMetadata> {
    private final SM4EncryptionMetadata metadata;
    boolean closed = false;
    private final DigestInputStream digestStream;
    private final CountingInputStream counterStream;

    public SM4EncryptionInputStream(InputStream originalStream, String encodeSpec, Cipher cipher) {
        super(originalStream);
        this.metadata = new SM4EncryptionMetadata(encodeSpec);
        try {
            this.counterStream = new CountingInputStream(originalStream);
            this.digestStream = new DigestInputStream((InputStream)this.counterStream, MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER));
            this.in = new CipherInputStream(this.digestStream, cipher);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to initialize digest", e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.counterStream.getByteCount());
        this.metadata.setOriginalDigest(this.digestStream.getMessageDigest().digest());
        this.notifyListeners();
    }

    public SM4EncryptionMetadata getEncodeMetadata() {
        return this.metadata;
    }
}

