/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption.sm4;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeListener;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.EncodeStream;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.opoo.ootp.codec.Codec;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.KeyAndSpec;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionInputStream;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionMetadata;
import org.opoo.ootp.codec.encryption.sm4.SM4EncryptionOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4EncryptionCodec
extends AbstractCodec<SM4EncryptionMetadata> {
    private static final Logger log = LoggerFactory.getLogger(SM4EncryptionCodec.class);
    public static final String SM4_CBC_PKCS5_CIPHER = "SM4/CBC/PKCS5Padding";
    public static final int PRIORITY = 2000;
    public static final String PROP_KEY_PROVIDER = "org.opoo.ootp.codec.encryption.sm4.SM4EncryptionCodec.keyProvider";

    protected boolean canProcess(String encodeSpec) {
        return "SM4".equals(CodecUtil.getEncodeType((String)encodeSpec));
    }

    public SM4EncryptionMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        return new SM4EncryptionMetadata(encodeSpec, metaMap);
    }

    public long getDecodedSize(SM4EncryptionMetadata metadata) {
        return metadata.getOriginalSize();
    }

    public OutputStream getDecodingStream(OutputStream originalStream, SM4EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        Cipher cipher = this.createDecryptCipher(metadata, codecProperties);
        return new CipherOutputStream(originalStream, cipher);
    }

    public InputStream getDecodingStream(InputStream originalStream, SM4EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        Cipher cipher = this.createDecryptCipher(metadata, codecProperties);
        return new CipherInputStream(originalStream, cipher);
    }

    protected Cipher createDecryptCipher(SM4EncryptionMetadata metadata, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtils.getCipherSpec(metadata.getEncodeSpec());
        KeyAndSpecProvider keyProvider = (KeyAndSpecProvider)Codec.getContextProperty(codecProperties, PROP_KEY_PROVIDER, () -> new EncryptionException("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u5f53\u524d\u89e3\u5bc6\u8fc7\u7a0b\u7f3a\u5c11\u5bc6\u94a5\u4ed3\u5e93"));
        String keyHash = metadata.getKeyHash();
        log.debug("\u6839\u636e\u5bc6\u94a5\u54c8\u5e0c\u67e5\u627e\u5bf9\u5e94\u7684\u5bc6\u94a5\uff1a{}", (Object)keyHash);
        KeyAndSpec keyAndSpec = keyProvider.getKey(keyHash);
        if (keyAndSpec == null) {
            throw new EncryptionException(String.format("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u7f3a\u5c11\u5bf9\u5e94\u7684\u5bc6\u94a5\uff0c\u5bc6\u94a5\u54c8\u5e0c: %s", keyHash));
        }
        return EncryptionUtils.initDecryptCipher(cipherSpec, keyAndSpec);
    }

    public String getDefaultEncodeSpec() {
        return CodecUtil.getEncodeSpec((String)"SM4", (String)SM4_CBC_PKCS5_CIPHER);
    }

    public int getPriority() {
        return 2000;
    }

    public boolean isSizePredictable() {
        return false;
    }

    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        throw new UnsupportedOperationException("SM4 encoded size is unpredictable");
    }

    public EncodeOutputStream<SM4EncryptionMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        CipherAndKeyProvider cipherAndKeyProvider = this.createEncryptCipher(encodeSpec, codecProperties);
        SM4EncryptionOutputStream outputStream = new SM4EncryptionOutputStream(originalStream, encodeSpec, cipherAndKeyProvider.getCipher());
        outputStream.addListener(new SigningEncodeMetadataListener(cipherAndKeyProvider.getKeyProvider()));
        return outputStream;
    }

    public EncodeInputStream<SM4EncryptionMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        CipherAndKeyProvider cipherAndKeyProvider = this.createEncryptCipher(encodeSpec, codecProperties);
        SM4EncryptionInputStream inputStream = new SM4EncryptionInputStream(originalStream, encodeSpec, cipherAndKeyProvider.getCipher());
        inputStream.addListener(new SigningEncodeMetadataListener(cipherAndKeyProvider.getKeyProvider()));
        return inputStream;
    }

    protected CipherAndKeyProvider createEncryptCipher(String encodeSpec, Map<String, Object> codecProperties) {
        String cipherSpec = EncryptionUtils.getCipherSpec(encodeSpec);
        KeyAndSpecProvider keyProvider = (KeyAndSpecProvider)Codec.getContextProperty(codecProperties, PROP_KEY_PROVIDER, () -> new EncryptionException("\u627e\u4e0d\u5230\u52a0\u5bc6\u7684\u5bc6\u94a5\u4fe1\u606f"));
        KeyAndSpec masterKey = keyProvider.getMasterKey();
        return new CipherAndKeyProvider(EncryptionUtils.initEncryptCipher(cipherSpec, masterKey), keyProvider);
    }

    protected static class CipherAndKeyProvider {
        private final Cipher cipher;
        private final KeyAndSpecProvider keyProvider;

        CipherAndKeyProvider(Cipher cipher, KeyAndSpecProvider keyProvider) {
            this.cipher = cipher;
            this.keyProvider = keyProvider;
        }

        public Cipher getCipher() {
            return this.cipher;
        }

        public KeyAndSpecProvider getKeyProvider() {
            return this.keyProvider;
        }
    }

    protected static class SigningEncodeMetadataListener
    implements EncodeListener<SM4EncryptionMetadata> {
        private final KeyAndSpecProvider keyProvider;

        public SigningEncodeMetadataListener(KeyAndSpecProvider keyProvider) {
            this.keyProvider = keyProvider;
        }

        public void encodeComplete(EncodeStream<SM4EncryptionMetadata> encodeStream) {
            ((SM4EncryptionMetadata)encodeStream.getEncodeMetadata()).setKeyHash(this.keyProvider.getMasterKeyHash());
        }
    }
}

