/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import org.opoo.ootp.codec.encryption.BasicPrivateKeyProvider;

public class KeyStorePrivateKeyProvider
extends BasicPrivateKeyProvider {
    public KeyStorePrivateKeyProvider(KeyStore keyStore, char[] keyStorePass, String ... privateKeyAliases) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeyException {
        super(new PrivateKey[0]);
        for (String alias : privateKeyAliases) {
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyStorePass);
            if (privateKey == null) {
                throw new InvalidKeyException("Private key for alias " + alias + " not found");
            }
            this.addKey(privateKey);
        }
    }
}

