/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import com.emc.codec.util.CodecUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.opoo.ootp.codec.encryption.EncryptionException;
import org.opoo.ootp.codec.encryption.KeyAndSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtils {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtils.class);
    public static final Provider SECURITY_PROVIDER = new BouncyCastleProvider();
    public static final String SECURE_RANDOM_INSTANCE = "DEFAULT";

    public static String getKeyFingerprint(PublicKey publicKey) {
        if (publicKey instanceof ECPublicKey) {
            return EncryptionUtils.getKeyFingerprint((ECPublicKey)publicKey);
        }
        throw new IllegalArgumentException("\u4e0d\u662f ECPublicKey: " + publicKey);
    }

    public static String getKeyFingerprint(ECPublicKey ecPublicKey) {
        ECPoint q = ecPublicKey.getQ();
        ECParameterSpec spec = ecPublicKey.getParameters();
        return ECUtil.generateKeyFingerprint((ECPoint)q, (ECParameterSpec)spec);
    }

    public static String getKeyFingerprint(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            return EncryptionUtils.getKeyFingerprint((ECPrivateKey)privateKey);
        }
        throw new IllegalArgumentException("\u4e0d\u662f ECPrivateKey: " + privateKey);
    }

    public static String getKeyFingerprint(ECPrivateKey ecPrivateKey) {
        BigInteger d = ecPrivateKey.getD();
        ECParameterSpec spec = ecPrivateKey.getParameters();
        ECPoint q = new FixedPointCombMultiplier().multiply(spec.getG(), d).normalize();
        return ECUtil.generateKeyFingerprint((ECPoint)q, (ECParameterSpec)spec);
    }

    public static String getKeyHash(Key secretKey) {
        return SmUtil.sm3().digestHex(secretKey.getEncoded());
    }

    public static KeyPair buildSM2KeyPairFromBase64(String publicKey, String privateKey) throws GeneralSecurityException {
        byte[] pubKeyBytes = Optional.ofNullable(publicKey).map(Base64.getDecoder()::decode).orElse(null);
        byte[] privKeyBytes = Optional.ofNullable(privateKey).map(Base64.getDecoder()::decode).orElse(null);
        return EncryptionUtils.buildSM2KeyPair(pubKeyBytes, privKeyBytes);
    }

    public static byte[] decodeHex(String string) {
        try {
            return Hex.decodeHex((String)string);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyPair buildSM2KeyPairFromHex(String publicKey, String privateKey) throws GeneralSecurityException {
        byte[] pubKeyBytes = Optional.ofNullable(publicKey).map(EncryptionUtils::decodeHex).orElse(null);
        byte[] privKeyBytes = Optional.ofNullable(privateKey).map(EncryptionUtils::decodeHex).orElse(null);
        return EncryptionUtils.buildSM2KeyPair(pubKeyBytes, privKeyBytes);
    }

    public static KeyPair buildSM2KeyPair(byte[] pubKeyBytes, byte[] privKeyBytes) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("EC", SECURITY_PROVIDER);
        PublicKey pubKey = pubKeyBytes == null ? null : keyFactory.generatePublic(new X509EncodedKeySpec(pubKeyBytes));
        PrivateKey privKey = privKeyBytes == null ? null : keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privKeyBytes));
        return new KeyPair(pubKey, privKey);
    }

    public static PublicKey buildSM2PublicKey(byte[] publicKeyBytes) throws GeneralSecurityException {
        return EncryptionUtils.buildSM2KeyPair(publicKeyBytes, null).getPublic();
    }

    public static PrivateKey buildSM2PrivateKey(byte[] privateKeyBytes) throws GeneralSecurityException {
        return EncryptionUtils.buildSM2KeyPair(null, privateKeyBytes).getPrivate();
    }

    public static PublicKey buildSM2PublicKeyFromBase64(String publicKey) throws GeneralSecurityException {
        return EncryptionUtils.buildSM2PublicKey(Base64.getDecoder().decode(publicKey));
    }

    public static PrivateKey buildSM2PrivateKeyFromBase64(String privateKey) throws GeneralSecurityException {
        return EncryptionUtils.buildSM2PrivateKey(Base64.getDecoder().decode(privateKey));
    }

    public static KeyPair generateSM2KeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", SECURITY_PROVIDER);
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec("sm2p256v1");
            keyPairGenerator.initialize(sm2p256v1, EncryptionUtils.getSecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            log.debug("Generated SM2 key pair: {}", (Object)keyPair);
            return keyPair;
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("\u65e0\u6cd5\u751f\u6210 SM2 \u7684\u516c\u94a5\u79c1\u94a5\u5bf9", e);
        }
    }

    public static SecretKey decryptKey(String encodedKey, String algorithm, PrivateKey privateKey) {
        byte[] decryptedKey;
        byte[] keyData = EncryptionUtils.urlSafeDecodeBase64(encodedKey);
        SM2 sm2 = SmUtil.sm2((PrivateKey)privateKey, null);
        try {
            decryptedKey = sm2.decrypt(keyData);
        }
        catch (CryptoException e) {
            if (e.getCause() instanceof InvalidCipherTextException) {
                log.debug("\u9ed8\u8ba4\u62fc\u63a5\u65b9\u5f0f\u89e3\u5bc6\u5931\u8d25\uff0c\u5c1d\u8bd5\u4f7f\u7528 C1C2C3 \u7684\u62fc\u63a5\u65b9\u5f0f\u91cd\u65b0\u5c1d\u8bd5\u89e3\u5bc6");
                decryptedKey = sm2.setMode(SM2Engine.Mode.C1C2C3).decrypt(keyData);
            }
            throw e;
        }
        return new SecretKeySpec(decryptedKey, algorithm);
    }

    public static String encryptKey(SecretKey key, PublicKey publicKey) {
        byte[] encryptedKey = SmUtil.sm2(null, (PublicKey)publicKey).encrypt(key.getEncoded());
        return EncryptionUtils.urlSafeEncodeBase64(encryptedKey);
    }

    public static String urlSafeEncodeBase64(byte[] data) {
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static byte[] urlSafeDecodeBase64(String b64Data) {
        return Base64.getUrlDecoder().decode(b64Data);
    }

    public static String signMetadata(Map<String, String> metadata, PrivateKey privateKey, String metaPrefix) {
        String canonicalString = metadata.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(((String)entry.getKey()).toLowerCase(), (String)entry.getValue())).filter(entry -> ((String)entry.getKey()).startsWith(metaPrefix)).sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue() + "\n").collect(Collectors.joining(""));
        log.debug("Canonical string: ''{}''", (Object)canonicalString);
        byte[] bytes = canonicalString.getBytes(StandardCharsets.UTF_8);
        byte[] signature = SmUtil.sm2((PrivateKey)privateKey, null).sign(bytes);
        return EncryptionUtils.urlSafeEncodeBase64(signature);
    }

    public static String getCipherSpec(String encodeSpec) {
        return CodecUtil.getEncodeAlgorithm((String)encodeSpec);
    }

    public static String getBaseAlgorithm(String cipherSpec) {
        return cipherSpec.split("/")[0];
    }

    public static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance(SECURE_RANDOM_INSTANCE, SECURITY_PROVIDER);
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not get secure random instance for DEFAULT", e);
        }
    }

    public static SecretKey generateKey(String cipherSpec) {
        String baseAlgorithm = EncryptionUtils.getBaseAlgorithm(cipherSpec);
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(baseAlgorithm, SECURITY_PROVIDER);
            keyGenerator.init(EncryptionUtils.getSecureRandom());
            return keyGenerator.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not generate key for algorithm " + baseAlgorithm, e);
        }
    }

    public static Cipher initEncryptCipher(String cipherSpec, KeyAndSpec key) {
        return EncryptionUtils.initCipher(cipherSpec, 1, key.getKey(), key.getSpec());
    }

    public static Cipher initDecryptCipher(String cipherSpec, KeyAndSpec key) {
        return EncryptionUtils.initCipher(cipherSpec, 2, key.getKey(), key.getSpec());
    }

    public static Cipher initCipher(String cipherSpec, int mode, Key key, AlgorithmParameterSpec spec) {
        try {
            Cipher cipher = Cipher.getInstance(cipherSpec, SECURITY_PROVIDER);
            if (spec != null) {
                cipher.init(mode, key, spec, EncryptionUtils.getSecureRandom());
            } else {
                cipher.init(mode, key, EncryptionUtils.getSecureRandom());
            }
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new EncryptionException("Error initializing cipher", e);
        }
    }

    public static KeyAndSpec buildSM4Key(byte[] key, byte[] iv) {
        SecretKeySpec sm4 = new SecretKeySpec(key, "SM4");
        IvParameterSpec ivParameterSpec = iv != null ? new IvParameterSpec(iv) : null;
        return new KeyAndSpec(sm4, ivParameterSpec);
    }
}

