/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption;

import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.PrivateKeyProvider;

public class BasicPrivateKeyProvider
implements PrivateKeyProvider {
    private final Map<String, PrivateKey> keyMap = new HashMap<String, PrivateKey>();

    public BasicPrivateKeyProvider(PrivateKey ... keys) {
        this.withKeys(keys);
    }

    @Override
    public PrivateKey getKey(String fingerprint) {
        return this.keyMap.get(fingerprint);
    }

    public BasicPrivateKeyProvider addKey(PrivateKey privateKey) {
        return this.addKey(EncryptionUtils.getKeyFingerprint(privateKey), privateKey);
    }

    public BasicPrivateKeyProvider addKey(String fingerprint, PrivateKey privateKey) {
        this.keyMap.put(fingerprint, privateKey);
        return this;
    }

    public void removeKey(PrivateKey privateKey) {
        this.keyMap.remove(EncryptionUtils.getKeyFingerprint(privateKey));
    }

    public BasicPrivateKeyProvider withKeys(PrivateKey ... keys) {
        this.keyMap.clear();
        for (PrivateKey key : keys) {
            this.addKey(key);
        }
        return this;
    }
}

