/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.encryption;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;
import org.opoo.ootp.codec.encryption.EncryptionUtils;
import org.opoo.ootp.codec.encryption.KeyAndSpec;
import org.opoo.ootp.codec.encryption.KeyAndSpecProvider;

public class BasicKeyAndSpecProvider
implements KeyAndSpecProvider {
    private KeyAndSpec masterKey;
    private String keyHash;
    private final Map<String, KeyAndSpec> keyMap = new HashMap<String, KeyAndSpec>();

    public BasicKeyAndSpecProvider() {
    }

    public BasicKeyAndSpecProvider(KeyAndSpec masterKey, KeyAndSpec ... keyAndSpecs) {
        this.setMasterKey(masterKey);
        for (KeyAndSpec keyAndSpec : keyAndSpecs) {
            this.addKey(keyAndSpec);
        }
    }

    public BasicKeyAndSpecProvider(Key key, IvParameterSpec spec) {
        this(new KeyAndSpec(key, spec), new KeyAndSpec[0]);
    }

    public BasicKeyAndSpecProvider(Key key) {
        this(key, null);
    }

    @Override
    public KeyAndSpec getMasterKey() {
        return this.masterKey;
    }

    public void setMasterKey(KeyAndSpec masterKey) {
        this.masterKey = masterKey;
        this.keyHash = EncryptionUtils.getKeyHash(masterKey.getKey());
        this.addKey(this.keyHash, masterKey);
    }

    @Override
    public String getMasterKeyHash() {
        return this.keyHash;
    }

    @Override
    public KeyAndSpec getKey(String keyHash) {
        return this.keyMap.get(keyHash);
    }

    public BasicKeyAndSpecProvider addKey(KeyAndSpec keyAndSpec) {
        return this.addKey(EncryptionUtils.getKeyHash(keyAndSpec.getKey()), keyAndSpec);
    }

    public BasicKeyAndSpecProvider addKey(Key key, IvParameterSpec spec) {
        return this.addKey(new KeyAndSpec(key, spec));
    }

    public BasicKeyAndSpecProvider addKey(String keyHash, KeyAndSpec keyAndSpec) {
        this.keyMap.put(keyHash, keyAndSpec);
        return this;
    }

    public void removeKey(KeyAndSpec keyAndSpec) {
        this.keyMap.remove(EncryptionUtils.getKeyHash(keyAndSpec.getKey()));
    }

    public BasicKeyAndSpecProvider withMasterKey(KeyAndSpec masterKey) {
        this.setMasterKey(masterKey);
        return this;
    }

    public BasicKeyAndSpecProvider withKeys(KeyAndSpec ... keys) {
        this.keyMap.clear();
        for (KeyAndSpec key : keys) {
            this.addKey(key);
        }
        return this;
    }
}

