/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.binary.base64;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.util.CodecUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.opoo.ootp.codec.binary.BinaryEncodeMetadata;
import org.opoo.ootp.codec.binary.base64.Base64EncodeInputStream;
import org.opoo.ootp.codec.binary.base64.Base64EncodeOutputStream;

public class Base64Codec
extends AbstractCodec<BinaryEncodeMetadata> {
    public static final String BASE64 = "base64";

    protected boolean canProcess(String encodeSpec) {
        String encodeType = CodecUtil.getEncodeType((String)encodeSpec);
        String encodeAlgorithm = CodecUtil.getEncodeAlgorithm((String)encodeSpec);
        return "BIN".equals(encodeType) && BASE64.equalsIgnoreCase(encodeAlgorithm);
    }

    public BinaryEncodeMetadata createEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        return new BinaryEncodeMetadata(encodeSpec, metaMap);
    }

    public long getDecodedSize(BinaryEncodeMetadata metadata) {
        return metadata.getOriginalSize();
    }

    public OutputStream getDecodingStream(OutputStream originalStream, BinaryEncodeMetadata metadata, Map<String, Object> codecProperties) {
        return new Base64OutputStream(originalStream, false);
    }

    public InputStream getDecodingStream(InputStream originalStream, BinaryEncodeMetadata metadata, Map<String, Object> codecProperties) {
        return new Base64InputStream(originalStream, false);
    }

    public String getDefaultEncodeSpec() {
        return CodecUtil.getEncodeSpec((String)"BIN", (String)BASE64);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public boolean isSizePredictable() {
        return false;
    }

    public long getEncodedSize(long originalSize, String encodeSpec, Map<String, Object> codecProperties) {
        throw new UnsupportedOperationException("base64 encoded size is unpredictable");
    }

    public EncodeOutputStream<BinaryEncodeMetadata> getEncodingStream(OutputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        return new Base64EncodeOutputStream(originalStream, encodeSpec);
    }

    public EncodeInputStream<BinaryEncodeMetadata> getEncodingStream(InputStream originalStream, String encodeSpec, Map<String, Object> codecProperties) {
        return new Base64EncodeInputStream(originalStream, encodeSpec);
    }
}

