/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.binary;

import com.emc.codec.EncodeOutputStream;
import com.emc.codec.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.opoo.ootp.codec.binary.BinaryCodecException;
import org.opoo.ootp.codec.binary.BinaryEncodeMetadata;
import org.opoo.ootp.codec.encryption.EncryptionUtils;

public abstract class BinaryEncodeOutputStream
extends EncodeOutputStream<BinaryEncodeMetadata> {
    boolean closed;
    private final BinaryEncodeMetadata metadata;
    private final DigestOutputStream digestOutputStream;
    private final CountingOutputStream encodedCounter;
    private final CountingOutputStream unencodedCounter;

    public BinaryEncodeOutputStream(OutputStream originalStream, String encodeSpec) {
        super(originalStream);
        this.metadata = new BinaryEncodeMetadata(encodeSpec);
        try {
            this.encodedCounter = new CountingOutputStream(originalStream);
            OutputStream binaryEncodeOutputStream = this.getBinaryEncodeOutputStream((OutputStream)this.encodedCounter);
            this.unencodedCounter = new CountingOutputStream(binaryEncodeOutputStream);
            this.digestOutputStream = new DigestOutputStream((OutputStream)this.unencodedCounter, MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER));
            this.out = this.digestOutputStream;
        }
        catch (NoSuchAlgorithmException e) {
            throw new BinaryCodecException("Unable to initialize digest", e);
        }
        catch (IOException e) {
            throw new BinaryCodecException("Could not create encode input stream", e);
        }
    }

    protected abstract OutputStream getBinaryEncodeOutputStream(OutputStream var1) throws IOException;

    public BinaryEncodeMetadata getEncodeMetadata() {
        return this.metadata;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.unencodedCounter.getByteCount());
        this.metadata.setEncodedSize(this.encodedCounter.getByteCount());
        this.metadata.setOriginalDigest(this.digestOutputStream.getMessageDigest().digest());
        this.notifyListeners();
    }
}

