/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.binary;

import com.emc.codec.EncodeMetadata;
import com.emc.codec.encryption.EncryptionUtil;
import com.emc.codec.util.CodecUtil;
import java.util.HashMap;
import java.util.Map;
import org.opoo.ootp.codec.binary.BinaryCodecException;
import org.opoo.ootp.codec.binary.BinaryEncodeConstants;
import org.opoo.ootp.codec.encryption.EncryptionUtils;

public class BinaryEncodeMetadata
extends EncodeMetadata {
    private long originalSize;
    private long encodedSize;
    private byte[] originalDigest;

    public BinaryEncodeMetadata(String encodeSpec) {
        super(encodeSpec);
        String encodeType = CodecUtil.getEncodeType((String)encodeSpec);
        String encodeAlgorithm = CodecUtil.getEncodeAlgorithm((String)encodeSpec);
        if (!"BIN".equals(encodeType) || !"base64".equalsIgnoreCase(encodeAlgorithm)) {
            throw new IllegalArgumentException("encodeSpec \u4e0d\u662f base64 \u7c7b\u578b");
        }
    }

    public BinaryEncodeMetadata(String encodeSpec, Map<String, String> metaMap) {
        this(encodeSpec);
        String originalSizeStr = metaMap.get(BinaryEncodeConstants.META_BIN_UNENCODED_SIZE);
        if (originalSizeStr == null) {
            throw new BinaryCodecException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11 Base64 \u7f16\u7801\u524d\u7684\u6570\u636e\u5927\u5c0f\u3002");
        }
        this.originalSize = Long.parseLong(originalSizeStr);
        String encodedSizeStr = metaMap.get(BinaryEncodeConstants.META_BIN_ENCODED_SIZE);
        if (encodedSizeStr == null) {
            throw new BinaryCodecException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11 Base64 \u7f16\u7801\u540e\u7684\u6570\u636e\u5927\u5c0f\u3002");
        }
        this.encodedSize = Long.parseLong(encodedSizeStr);
        String originalDigestStr = metaMap.get(BinaryEncodeConstants.META_BIN_UNENCODED_SM3);
        if (originalDigestStr == null) {
            throw new BinaryCodecException("\u5143\u6570\u636e\u4e2d\u7f3a\u5c11 Base64 \u7f16\u7801\u524d\u6570\u636e\u7684 SM3 \u6458\u8981\u503c\u3002");
        }
        this.originalDigest = EncryptionUtils.decodeHex(originalDigestStr);
    }

    public boolean isComplete() {
        return this.originalSize > 0L && this.encodedSize > 0L;
    }

    public Map<String, String> toMap() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        if (this.isComplete()) {
            metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SIZE, "" + this.originalSize);
            metaMap.put(BinaryEncodeConstants.META_BIN_ENCODED_SIZE, "" + this.encodedSize);
            metaMap.put(BinaryEncodeConstants.META_BIN_UNENCODED_SM3, EncryptionUtil.toHexPadded((byte[])this.originalDigest));
        }
        return metaMap;
    }

    public long getOriginalSize() {
        return this.originalSize;
    }

    public void setOriginalSize(long originalSize) {
        this.originalSize = originalSize;
    }

    public long getEncodedSize() {
        return this.encodedSize;
    }

    public void setEncodedSize(long encodedSize) {
        this.encodedSize = encodedSize;
    }

    public void setOriginalDigest(byte[] originalDigest) {
        this.originalDigest = originalDigest;
    }
}

