/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec.binary;

import com.emc.codec.EncodeInputStream;
import com.emc.codec.util.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.opoo.ootp.codec.binary.BinaryCodecException;
import org.opoo.ootp.codec.binary.BinaryEncodeMetadata;
import org.opoo.ootp.codec.encryption.EncryptionUtils;

public abstract class BinaryEncodeInputStream
extends EncodeInputStream<BinaryEncodeMetadata> {
    boolean closed;
    private final BinaryEncodeMetadata metadata;
    private final DigestInputStream digestInputStream;
    private final CountingInputStream unencodedCounter;
    private final CountingInputStream encodedCounter;

    public BinaryEncodeInputStream(InputStream originalStream, String encodeSpec) {
        super(originalStream);
        this.metadata = new BinaryEncodeMetadata(encodeSpec);
        try {
            this.unencodedCounter = new CountingInputStream(originalStream);
            this.digestInputStream = new DigestInputStream((InputStream)this.unencodedCounter, MessageDigest.getInstance("SM3", EncryptionUtils.SECURITY_PROVIDER));
            InputStream binaryEncodeInputStream = this.getBinaryEncodeInputStream(this.digestInputStream);
            this.encodedCounter = new CountingInputStream(binaryEncodeInputStream);
            this.in = this.encodedCounter;
        }
        catch (NoSuchAlgorithmException e) {
            throw new BinaryCodecException("Unable to initialize digest", e);
        }
        catch (IOException e) {
            throw new BinaryCodecException("Could not create encode input stream", e);
        }
    }

    protected abstract InputStream getBinaryEncodeInputStream(InputStream var1) throws IOException;

    public BinaryEncodeMetadata getEncodeMetadata() {
        return this.metadata;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        this.metadata.setOriginalSize(this.unencodedCounter.getByteCount());
        this.metadata.setEncodedSize(this.encodedCounter.getByteCount());
        this.metadata.setOriginalDigest(this.digestInputStream.getMessageDigest().digest());
        this.notifyListeners();
    }
}

