/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.ootp.codec;

import com.emc.codec.AbstractCodec;
import com.emc.codec.EncodeInputStream;
import com.emc.codec.EncodeMetadata;
import com.emc.codec.EncodeOutputStream;
import com.emc.codec.EncodeStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opoo.ootp.codec.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecEncoder
extends Codec<CodecEncoder> {
    private static final Logger log = LoggerFactory.getLogger(CodecEncoder.class);
    private final Map<AbstractCodec, String> encoders = new LinkedHashMap<AbstractCodec, String>();

    public CodecEncoder(String ... encodeSpecs) {
        ServiceLoader<AbstractCodec> load = ServiceLoader.load(AbstractCodec.class);
        List allCodecs = StreamSupport.stream(load.spliterator(), false).sorted().collect(Collectors.toList());
        for (String encodeSpec : encodeSpecs) {
            log.debug("\u67e5\u627e {} \u5bf9\u5e94\u7684 Codec", (Object)encodeSpec);
            AbstractCodec abstractCodec = allCodecs.stream().filter(codec -> codec.canEncode(encodeSpec)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported encoder: " + encodeSpec));
            this.encoders.put(abstractCodec, encodeSpec);
        }
    }

    public InputStream getEncodeStream(InputStream sourceStream, Map<String, String> completeMetaMap) {
        return this.getEncodeStream(sourceStream, completeMetaMap, null);
    }

    public InputStream getEncodeStream(InputStream sourceStream, Map<String, String> completeMetaMap, Map<String, Object> context) {
        Map<String, Object> codecProperties = this.buildCodecProperties(context);
        for (Map.Entry<AbstractCodec, String> entry : this.encoders.entrySet()) {
            AbstractCodec codec = entry.getKey();
            String encodeSpec = entry.getValue();
            log.debug("Codec wrap input stream\uff1a{}", (Object)codec);
            sourceStream = codec.getEncodingStream(sourceStream, encodeSpec, codecProperties);
        }
        return new MetaAddingInputStream((EncodeInputStream)sourceStream, completeMetaMap);
    }

    public OutputStream getEncodeStream(OutputStream targetStream, Map<String, String> completeMetaMap) {
        return this.getEncodeStream(targetStream, completeMetaMap, null);
    }

    public OutputStream getEncodeStream(OutputStream targetStream, Map<String, String> completeMetaMap, Map<String, Object> context) {
        Map<String, Object> codecProperties = this.buildCodecProperties(context);
        ArrayList<Map.Entry<AbstractCodec, String>> list = new ArrayList<Map.Entry<AbstractCodec, String>>(this.encoders.entrySet());
        for (int i = list.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            AbstractCodec codec = (AbstractCodec)entry.getKey();
            String encodeSpec = (String)entry.getValue();
            log.debug("Codec wrap output stream\uff1a{}", (Object)codec);
            targetStream = codec.getEncodingStream(targetStream, encodeSpec, codecProperties);
        }
        return new MetaAddingOutputStream((EncodeOutputStream)targetStream, completeMetaMap);
    }

    protected static void addEncodeMetadata(Map<String, String> metaMap, EncodeStream encodeStream, boolean addEncodeSpec) {
        boolean complete = true;
        encodeStream = encodeStream.getChainHead();
        do {
            EncodeMetadata metadata;
            if (!(metadata = encodeStream.getEncodeMetadata()).isComplete()) {
                complete = false;
            }
            metaMap.putAll(metadata.toMap());
            if (!addEncodeSpec) continue;
            CodecEncoder.addEncodeSpec(metaMap, metadata.getEncodeSpec());
        } while ((encodeStream = encodeStream.getNext()) != null);
        metaMap.put(META_TRANSFORM_COMPLETE, "" + complete);
    }

    public static void addEncodeSpec(Map<String, String> metaMap, String encodeSpec) {
        String specString = metaMap.get(META_TRANSFORM_MODE);
        if (specString != null && specString.length() > 0) {
            encodeSpec = specString + "," + encodeSpec;
        }
        metaMap.put(META_TRANSFORM_MODE, encodeSpec);
    }

    public static class MetaAddingInputStream
    extends FilterInputStream {
        private final EncodeInputStream lastInputStream;
        private final Map<String, String> metaMap;

        public MetaAddingInputStream(EncodeInputStream lastInputStream, Map<String, String> metaMap) {
            super((InputStream)lastInputStream);
            this.lastInputStream = lastInputStream;
            this.metaMap = metaMap;
            CodecEncoder.addEncodeMetadata(metaMap, (EncodeStream)lastInputStream, true);
        }

        @Override
        public void close() throws IOException {
            super.close();
            CodecEncoder.addEncodeMetadata(this.metaMap, (EncodeStream)this.lastInputStream, false);
        }
    }

    public static class MetaAddingOutputStream
    extends FilterOutputStream {
        private final EncodeOutputStream firstOutputStream;
        private final Map<String, String> metaMap;

        public MetaAddingOutputStream(EncodeOutputStream firstOutputStream, Map<String, String> metaMap) {
            super((OutputStream)firstOutputStream);
            this.firstOutputStream = firstOutputStream;
            this.metaMap = metaMap;
            CodecEncoder.addEncodeMetadata(metaMap, (EncodeStream)firstOutputStream, true);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            CodecEncoder.addEncodeMetadata(this.metaMap, (EncodeStream)this.firstOutputStream, false);
        }
    }
}

